/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisInternalFieldDescription;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.redis.RedisTableFieldDescription;
import com.facebook.presto.redis.RedisTableFieldGroup;
import com.facebook.presto.redis.RedisTableHandle;
import com.facebook.presto.redis.RedisTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RedisMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(RedisMetadata.class);
    private final String connectorId;
    private final boolean hideInternalColumns;
    private final java.util.function.Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier;

    @Inject
    RedisMetadata(RedisConnectorId connectorId, RedisConnectorConfig redisConnectorConfig, java.util.function.Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        Objects.requireNonNull(redisConnectorConfig, "redisConfig is null");
        this.hideInternalColumns = redisConnectorConfig.isHideInternalColumns();
        log.debug("Loading redis table definitions from %s", new Object[]{redisConnectorConfig.getTableDescriptionDir().getAbsolutePath()});
        this.redisTableDescriptionSupplier = () -> ((Supplier)Suppliers.memoize(redisTableDescriptionSupplier::get)).get();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        Set schemas = this.getDefinedTables().keySet().stream().map(SchemaTableName::getSchemaName).collect(Collectors.toCollection(LinkedHashSet::new));
        return ImmutableList.copyOf((Collection)schemas);
    }

    public RedisTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        String keyName = null;
        if (table.getKey() != null) {
            keyName = table.getKey().getName();
        }
        return new RedisTableHandle(this.connectorId, schemaTableName.getSchemaName(), schemaTableName.getTableName(), RedisMetadata.getDataFormat(table.getKey()), RedisMetadata.getDataFormat(table.getValue()), keyName);
    }

    private static String getDataFormat(RedisTableFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(RedisHandleResolver.convertTableHandle(tableHandle).toSchemaTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        RedisTableHandle tableHandle = RedisHandleResolver.convertTableHandle(table);
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new RedisTableLayoutHandle(tableHandle));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        RedisTableLayoutHandle layout = RedisHandleResolver.convertLayout(handle);
        return this.getTableLayouts(session, layout.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).get(0).getTableLayout();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            if (schemaNameOrNull != null && !tableName.getSchemaName().equals(schemaNameOrNull)) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<RedisTableFieldDescription> fields;
        RedisTableFieldGroup value;
        List<RedisTableFieldDescription> fields2;
        RedisTableHandle redisTableHandle = RedisHandleResolver.convertTableHandle(tableHandle);
        RedisTableDescription redisTableDescription = this.getDefinedTables().get(redisTableHandle.toSchemaTableName());
        if (redisTableDescription == null) {
            throw new TableNotFoundException(redisTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        RedisTableFieldGroup key = redisTableDescription.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (RedisTableFieldDescription field : fields2) {
                columnHandles.put((Object)field.getName(), (Object)field.getColumnHandle(this.connectorId, true, index));
                ++index;
            }
        }
        if ((value = redisTableDescription.getValue()) != null && (fields = value.getFields()) != null) {
            for (RedisTableFieldDescription field : fields) {
                columnHandles.put((Object)field.getName(), (Object)field.getColumnHandle(this.connectorId, false, index));
                ++index;
            }
        }
        for (RedisInternalFieldDescription field : RedisInternalFieldDescription.values()) {
            columnHandles.put((Object)field.getColumnName(), (Object)field.getColumnHandle(this.connectorId, index, this.hideInternalColumns));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        RedisHandleResolver.convertTableHandle(tableHandle);
        return RedisHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    @VisibleForTesting
    Map<SchemaTableName, RedisTableDescription> getDefinedTables() {
        return this.redisTableDescriptionSupplier.get();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.getKey());
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.getValue());
        for (RedisInternalFieldDescription fieldDescription : RedisInternalFieldDescription.values()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    private static void appendFields(ImmutableList.Builder<ColumnMetadata> builder, RedisTableFieldGroup group) {
        List<RedisTableFieldDescription> fields;
        if (group != null && (fields = group.getFields()) != null) {
            for (RedisTableFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata());
            }
        }
    }
}

