/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.RowDecoderFactory;
import com.facebook.presto.redis.RedisFieldDecoder;
import com.facebook.presto.redis.decoder.hash.HashRedisFieldDecoder;
import com.facebook.presto.redis.decoder.hash.HashRedisRowDecoder;
import com.facebook.presto.redis.decoder.hash.ISO8601HashRedisFieldDecoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class HashRedisRowDecoderFactory
implements RowDecoderFactory {
    public RowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        return new HashRedisRowDecoder(this.chooseFieldDecoders(columns));
    }

    private Map<DecoderColumnHandle, RedisFieldDecoder<String>> chooseFieldDecoders(Set<DecoderColumnHandle> columns) {
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::chooseFieldDecoder));
    }

    private RedisFieldDecoder<String> chooseFieldDecoder(DecoderColumnHandle column) {
        Preconditions.checkArgument((!column.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)column.getName());
        if (column.getDataFormat() == null) {
            return new HashRedisFieldDecoder();
        }
        if (column.getType().getJavaType() == Long.TYPE && "iso8601".equals(column.getDataFormat())) {
            return new ISO8601HashRedisFieldDecoder();
        }
        throw new IllegalArgumentException(String.format("unknown data format '%s' for column '%s'", column.getDataFormat(), column.getName()));
    }
}

