/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.airlift.log.Logger;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisJedisManager {
    private static final Logger log = Logger.get(RedisJedisManager.class);
    private final LoadingCache<HostAddress, JedisPool> jedisPoolCache;
    private final RedisConnectorConfig redisConnectorConfig;
    private final JedisPoolConfig jedisPoolConfig;

    @Inject
    RedisJedisManager(RedisConnectorConfig redisConnectorConfig, NodeManager nodeManager) {
        this.redisConnectorConfig = Objects.requireNonNull(redisConnectorConfig, "redisConfig is null");
        this.jedisPoolCache = CacheBuilder.newBuilder().build(CacheLoader.from(this::createConsumer));
        this.jedisPoolConfig = new JedisPoolConfig();
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry entry : this.jedisPoolCache.asMap().entrySet()) {
            try {
                ((JedisPool)entry.getValue()).destroy();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "While destroying JedisPool %s:", new Object[]{entry.getKey()});
            }
        }
    }

    public RedisConnectorConfig getRedisConnectorConfig() {
        return this.redisConnectorConfig;
    }

    public JedisPool getJedisPool(HostAddress host) {
        Objects.requireNonNull(host, "host is null");
        return (JedisPool)this.jedisPoolCache.getUnchecked((Object)host);
    }

    private JedisPool createConsumer(HostAddress host) {
        log.info("Creating new JedisPool for %s", new Object[]{host});
        return new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, host.getHostText(), host.getPort(), Math.toIntExact(this.redisConnectorConfig.getRedisConnectTimeout().toMillis()), this.redisConnectorConfig.getRedisPassword(), this.redisConnectorConfig.getRedisDataBaseIndex());
    }
}

