/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisTableFieldGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class RedisTableDescription {
    private final String tableName;
    private final String schemaName;
    private final RedisTableFieldGroup key;
    private final RedisTableFieldGroup value;

    @JsonCreator
    public RedisTableDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="key") RedisTableFieldGroup key, @JsonProperty(value="value") RedisTableFieldGroup value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.key = key;
        this.value = value;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public RedisTableFieldGroup getKey() {
        return this.key;
    }

    @JsonProperty
    public RedisTableFieldGroup getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("schemaName", (Object)this.schemaName).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }
}

