/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.decoder.DispatchingRowDecoderFactory;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisRecordSet;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class RedisRecordSetProvider
implements ConnectorRecordSetProvider {
    private final DispatchingRowDecoderFactory decoderFactory;
    private final RedisJedisManager jedisManager;

    @Inject
    public RedisRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, RedisJedisManager jedisManager) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        RedisSplit redisSplit = RedisHandleResolver.convertSplit(split);
        List redisColumns = (List)columns.stream().map(RedisHandleResolver::convertColumnHandle).collect(ImmutableList.toImmutableList());
        RowDecoder keyDecoder = this.decoderFactory.create(redisSplit.getKeyDataFormat(), Collections.emptyMap(), (Set)redisColumns.stream().filter(col -> !col.isInternal()).filter(RedisColumnHandle::isKeyDecoder).collect(ImmutableSet.toImmutableSet()));
        RowDecoder valueDecoder = this.decoderFactory.create(redisSplit.getValueDataFormat(), Collections.emptyMap(), (Set)redisColumns.stream().filter(col -> !col.isInternal()).filter(col -> !col.isKeyDecoder()).collect(ImmutableSet.toImmutableSet()));
        return new RedisRecordSet(redisSplit, this.jedisManager, redisColumns, keyDecoder, valueDecoder);
    }
}

