/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public enum RedisInternalFieldDescription {
    KEY_FIELD("_key", (Type)VarcharType.createUnboundedVarcharType(), "Key text"),
    VALUE_FIELD("_value", (Type)VarcharType.createUnboundedVarcharType(), "Value text"),
    VALUE_CORRUPT_FIELD("_value_corrupt", (Type)BooleanType.BOOLEAN, "Value data is corrupt"),
    VALUE_LENGTH_FIELD("_value_length", (Type)BigintType.BIGINT, "Total number of value bytes"),
    KEY_CORRUPT_FIELD("_key_corrupt", (Type)BooleanType.BOOLEAN, "Key data is corrupt"),
    KEY_LENGTH_FIELD("_key_length", (Type)BigintType.BIGINT, "Total number of key bytes");

    private static final Map<String, RedisInternalFieldDescription> BY_COLUMN_NAME;
    private final String columnName;
    private final Type type;
    private final String comment;

    public static RedisInternalFieldDescription forColumnName(String columnName) {
        RedisInternalFieldDescription description = BY_COLUMN_NAME.get(columnName);
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (String)"Unknown internal column name %s", (Object)columnName);
        return description;
    }

    private RedisInternalFieldDescription(String columnName, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.columnName = columnName;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    RedisColumnHandle getColumnHandle(String connectorId, int index, boolean hidden) {
        return new RedisColumnHandle(connectorId, index, this.getColumnName(), this.getType(), null, null, null, false, hidden, true);
    }

    ColumnMetadata getColumnMetadata(boolean hidden) {
        return new ColumnMetadata(this.columnName, this.type, this.comment, hidden);
    }

    static {
        BY_COLUMN_NAME = (Map)Arrays.stream(RedisInternalFieldDescription.values()).collect(ImmutableMap.toImmutableMap(RedisInternalFieldDescription::getColumnName, Function.identity()));
    }
}

