/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

class HashRedisValueProvider
extends FieldValueProvider {
    protected final DecoderColumnHandle columnHandle;
    protected final String value;

    public HashRedisValueProvider(DecoderColumnHandle columnHandle, String value) {
        this.columnHandle = columnHandle;
        this.value = value;
    }

    public boolean accept(DecoderColumnHandle handle) {
        return this.columnHandle.equals(handle);
    }

    public boolean isNull() {
        return this.value == null || this.value.isEmpty();
    }

    public boolean getBoolean() {
        return this.isNull() ? false : Boolean.parseBoolean(this.value.trim());
    }

    public long getLong() {
        return this.isNull() ? 0L : Long.parseLong(this.value.trim());
    }

    public double getDouble() {
        return this.isNull() ? 0.0 : Double.parseDouble(this.value.trim());
    }

    public Slice getSlice() {
        return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)this.value);
    }
}

