/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.redis.RedisDataType;
import com.facebook.presto.redis.RedisInternalFieldDescription;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(RedisRecordCursor.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final RowDecoder keyDecoder;
    private final RowDecoder valueDecoder;
    private final Map<DecoderColumnHandle, FieldDecoder<?>> keyFieldDecoders;
    private final Map<DecoderColumnHandle, FieldDecoder<?>> valueFieldDecoders;
    private final RedisSplit split;
    private final List<DecoderColumnHandle> columnHandles;
    private final RedisJedisManager redisJedisManager;
    private final JedisPool jedisPool;
    private final ScanParams scanParms;
    private ScanResult<String> redisCursor;
    private Iterator<String> keysIterator;
    private final AtomicBoolean reported = new AtomicBoolean();
    private FieldValueProvider[] fieldValueProviders;
    private String valueString;
    private Map<String, String> valueMap;
    private long totalBytes;
    private long totalValues;

    RedisRecordCursor(RowDecoder keyDecoder, RowDecoder valueDecoder, Map<DecoderColumnHandle, FieldDecoder<?>> keyFieldDecoders, Map<DecoderColumnHandle, FieldDecoder<?>> valueFieldDecoders, RedisSplit split, List<DecoderColumnHandle> columnHandles, RedisJedisManager redisJedisManager) {
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.keyFieldDecoders = keyFieldDecoders;
        this.valueFieldDecoders = valueFieldDecoders;
        this.split = split;
        this.columnHandles = columnHandles;
        this.redisJedisManager = redisJedisManager;
        this.jedisPool = redisJedisManager.getJedisPool(split.getNodes().get(0));
        this.scanParms = this.setScanParms();
        this.fetchKeys();
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getType();
    }

    public boolean hasUnscannedData() {
        if (this.redisCursor == null) {
            return false;
        }
        return !this.redisCursor.getStringCursor().equals("0");
    }

    public boolean advanceNextPosition() {
        while (!this.keysIterator.hasNext()) {
            if (!this.hasUnscannedData()) {
                return this.endOfData();
            }
            this.fetchKeys();
        }
        return this.nextRow(this.keysIterator.next());
    }

    private boolean endOfData() {
        if (!this.reported.getAndSet(true)) {
            log.debug("Read a total of %d values with %d bytes.", new Object[]{this.totalValues, this.totalBytes});
        }
        return false;
    }

    private boolean nextRow(String keyString) {
        this.fetchData(keyString);
        byte[] keyData = keyString.getBytes(StandardCharsets.UTF_8);
        byte[] valueData = EMPTY_BYTE_ARRAY;
        if (this.valueString != null) {
            valueData = this.valueString.getBytes(StandardCharsets.UTF_8);
        }
        this.totalBytes += (long)valueData.length;
        ++this.totalValues;
        HashSet<FieldValueProvider> fieldValueProviders = new HashSet<FieldValueProvider>();
        fieldValueProviders.add(RedisInternalFieldDescription.KEY_FIELD.forByteValue(keyData));
        fieldValueProviders.add(RedisInternalFieldDescription.VALUE_FIELD.forByteValue(valueData));
        fieldValueProviders.add(RedisInternalFieldDescription.KEY_LENGTH_FIELD.forLongValue(keyData.length));
        fieldValueProviders.add(RedisInternalFieldDescription.VALUE_LENGTH_FIELD.forLongValue(valueData.length));
        fieldValueProviders.add(RedisInternalFieldDescription.KEY_CORRUPT_FIELD.forBooleanValue(this.keyDecoder.decodeRow(keyData, null, fieldValueProviders, this.columnHandles, this.keyFieldDecoders)));
        fieldValueProviders.add(RedisInternalFieldDescription.VALUE_CORRUPT_FIELD.forBooleanValue(this.valueDecoder.decodeRow(valueData, this.valueMap, fieldValueProviders, this.columnHandles, this.valueFieldDecoders)));
        this.fieldValueProviders = new FieldValueProvider[this.columnHandles.size()];
        block0: for (int i = 0; i < this.columnHandles.size(); ++i) {
            for (FieldValueProvider fieldValueProvider : fieldValueProviders) {
                if (!fieldValueProvider.accept(this.columnHandles.get(i))) continue;
                this.fieldValueProviders[i] = fieldValueProvider;
                continue block0;
            }
        }
        return true;
    }

    public boolean getBoolean(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(field, Boolean.TYPE);
        return this.isNull(field) ? false : this.fieldValueProviders[field].getBoolean();
    }

    public long getLong(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(field, Long.TYPE);
        return this.isNull(field) ? 0L : this.fieldValueProviders[field].getLong();
    }

    public double getDouble(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(field, Double.TYPE);
        return this.isNull(field) ? 0.0 : this.fieldValueProviders[field].getDouble();
    }

    public Slice getSlice(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(field, Slice.class);
        return this.isNull(field) ? Slices.EMPTY_SLICE : this.fieldValueProviders[field].getSlice();
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.fieldValueProviders[field] == null || this.fieldValueProviders[field].isNull();
    }

    public Object getObject(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        throw new IllegalArgumentException(String.format("Type %s is not supported", this.getType(field)));
    }

    private void checkFieldType(int field, Class<?> expected) {
        Class actual = this.getType(field).getJavaType();
        Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
    }

    public void close() {
    }

    private ScanParams setScanParms() {
        if (this.split.getKeyDataType() == RedisDataType.STRING) {
            ScanParams scanParms = new ScanParams();
            scanParms.count(this.redisJedisManager.getRedisConnectorConfig().getRedisScanCount());
            if (this.redisJedisManager.getRedisConnectorConfig().isKeyPrefixSchemaTable()) {
                String keyMatch = "";
                if (!this.split.getSchemaName().equals("default")) {
                    keyMatch = this.split.getSchemaName() + Character.toString(this.redisJedisManager.getRedisConnectorConfig().getRedisKeyDelimiter());
                }
                keyMatch = keyMatch + this.split.getTableName() + Character.toString(this.redisJedisManager.getRedisConnectorConfig().getRedisKeyDelimiter()) + "*";
                scanParms.match(keyMatch);
            }
            return scanParms;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchKeys() {
        try (Jedis jedis = this.jedisPool.getResource();){
            switch (this.split.getKeyDataType()) {
                case STRING: {
                    String cursor = ScanParams.SCAN_POINTER_START;
                    if (this.redisCursor != null) {
                        cursor = this.redisCursor.getStringCursor();
                    }
                    log.debug("Scanning new Redis keys from cursor %s . %d values read so far", new Object[]{cursor, this.totalValues});
                    this.redisCursor = jedis.scan(cursor, this.scanParms);
                    List keys = this.redisCursor.getResult();
                    this.keysIterator = keys.iterator();
                    return true;
                }
                case ZSET: {
                    Set keys = jedis.zrange(this.split.getKeyName(), this.split.getStart(), this.split.getEnd());
                    this.keysIterator = keys.iterator();
                    return true;
                }
            }
            log.debug("Redis type of key %s is unsupported", new Object[]{this.split.getKeyDataFormat()});
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchData(String keyString) {
        this.valueString = null;
        this.valueMap = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            switch (this.split.getValueDataType()) {
                case STRING: {
                    this.valueString = jedis.get(keyString);
                    if (this.valueString != null) return true;
                    log.warn("Redis data modified while query was running, string value at key %s deleted", new Object[]{keyString});
                    boolean bl = false;
                    return bl;
                }
                case HASH: {
                    this.valueMap = jedis.hgetAll(keyString);
                    if (this.valueMap != null) return true;
                    log.warn("Redis data modified while query was running, hash value at key %s deleted", new Object[]{keyString});
                    boolean bl = false;
                    return bl;
                }
            }
            log.debug("Redis type for key %s is unsupported", new Object[]{keyString});
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

