/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnector;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisConnectorModule;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.redis.RedisTableDescriptionSupplier;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class RedisConnectorFactory
implements ConnectorFactory {
    private final Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier;

    RedisConnectorFactory(Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier) {
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
    }

    public String getName() {
        return "redis";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new RedisHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new RedisConnectorModule(), binder -> {
                binder.bind(RedisConnectorId.class).toInstance((Object)new RedisConnectorId(connectorId));
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                if (this.tableDescriptionSupplier.isPresent()) {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(){}).toInstance(this.tableDescriptionSupplier.get());
                } else {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(){}).to(RedisTableDescriptionSupplier.class).in(Scopes.SINGLETON);
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(RedisConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

