/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class RedisTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final String keyDataFormat;
    private final String keyName;
    private final String valueDataFormat;

    @JsonCreator
    public RedisTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="valueDataFormat") String valueDataFormat, @JsonProperty(value="keyName") String keyName) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.valueDataFormat = Objects.requireNonNull(valueDataFormat, "valueDataFormat is null");
        this.keyName = keyName;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getKeyName() {
        return this.keyName;
    }

    @JsonProperty
    public String getValueDataFormat() {
        return this.valueDataFormat;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName, this.keyDataFormat, this.valueDataFormat, this.keyName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RedisTableHandle other = (RedisTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.keyDataFormat, other.keyDataFormat) && Objects.equals(this.valueDataFormat, other.valueDataFormat) && Objects.equals(this.keyName, other.keyName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("keyDataFormat", (Object)this.keyDataFormat).add("valueDataFormat", (Object)this.valueDataFormat).add("keyName", (Object)this.keyName).toString();
    }
}

