/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.redis.decoder.hash.HashRedisValueProvider;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Set;

public class HashRedisFieldDecoder
implements FieldDecoder<String> {
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    public String getRowDecoderName() {
        return "hash";
    }

    public String getFieldDecoderName() {
        return "_default";
    }

    public FieldValueProvider decode(String value, DecoderColumnHandle columnHandle) {
        return new HashRedisValueProvider(columnHandle, value);
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

