/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.redis.RedisTableFieldDescription;
import com.facebook.presto.redis.RedisTableFieldGroup;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;

public class RedisTableDescriptionSupplier
implements Supplier<Map<SchemaTableName, RedisTableDescription>> {
    private static final Logger log = Logger.get(RedisTableDescriptionSupplier.class);
    private final RedisConnectorConfig redisConnectorConfig;
    private final JsonCodec<RedisTableDescription> tableDescriptionCodec;

    @Inject
    RedisTableDescriptionSupplier(RedisConnectorConfig redisConnectorConfig, JsonCodec<RedisTableDescription> tableDescriptionCodec) {
        this.redisConnectorConfig = Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.tableDescriptionCodec = Objects.requireNonNull(tableDescriptionCodec, "tableDescriptionCodec is null");
    }

    @Override
    public Map<SchemaTableName, RedisTableDescription> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (File file : RedisTableDescriptionSupplier.listFiles(this.redisConnectorConfig.getTableDescriptionDir())) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                RedisTableDescription table = (RedisTableDescription)this.tableDescriptionCodec.fromJson(Files.readAllBytes(file.toPath()));
                String schemaName = (String)MoreObjects.firstNonNull((Object)table.getSchemaName(), (Object)this.redisConnectorConfig.getDefaultSchema());
                log.debug("Redis table %s.%s: %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.build();
            log.debug("Loaded table definitions: %s", new Object[]{tableDefinitions.keySet()});
            builder = ImmutableMap.builder();
            for (String definedTable : this.redisConnectorConfig.getTableNames()) {
                SchemaTableName tableName;
                try {
                    tableName = SchemaTableName.valueOf((String)definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.redisConnectorConfig.getDefaultSchema(), definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) {
                    RedisTableDescription redisTable = (RedisTableDescription)tableDefinitions.get(tableName);
                    log.debug("Found Table definition for %s: %s", new Object[]{tableName, redisTable});
                    builder.put((Object)tableName, (Object)redisTable);
                    continue;
                }
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new RedisTableDescription(tableName.getTableName(), tableName.getSchemaName(), new RedisTableFieldGroup("dummy", null, (List<RedisTableFieldDescription>)ImmutableList.of()), new RedisTableFieldGroup("dummy", null, (List<RedisTableFieldDescription>)ImmutableList.of())));
            }
            return builder.build();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error: ");
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

