/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderRegistry;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisRecordSet;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class RedisRecordSetProvider
implements ConnectorRecordSetProvider {
    private final RedisJedisManager jedisManager;
    private final DecoderRegistry registry;

    @Inject
    public RedisRecordSetProvider(DecoderRegistry registry, RedisJedisManager jedisManager) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        RedisSplit redisSplit = RedisHandleResolver.convertSplit(split);
        ImmutableList.Builder handleBuilder = ImmutableList.builder();
        ImmutableMap.Builder keyFieldDecoderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder valueFieldDecoderBuilder = ImmutableMap.builder();
        RowDecoder keyDecoder = this.registry.getRowDecoder(redisSplit.getKeyDataFormat());
        RowDecoder valueDecoder = this.registry.getRowDecoder(redisSplit.getValueDataFormat());
        for (ColumnHandle columnHandle : columns) {
            FieldDecoder fieldDecoder;
            RedisColumnHandle columnHandle2 = RedisHandleResolver.convertColumnHandle(columnHandle);
            handleBuilder.add((Object)columnHandle2);
            if (columnHandle2.isInternal()) continue;
            if (columnHandle2.isKeyDecoder()) {
                fieldDecoder = this.registry.getFieldDecoder(redisSplit.getKeyDataFormat(), columnHandle2.getType().getJavaType(), columnHandle2.getDataFormat());
                keyFieldDecoderBuilder.put((Object)columnHandle2, (Object)fieldDecoder);
                continue;
            }
            fieldDecoder = this.registry.getFieldDecoder(redisSplit.getValueDataFormat(), columnHandle2.getType().getJavaType(), columnHandle2.getDataFormat());
            valueFieldDecoderBuilder.put((Object)columnHandle2, (Object)fieldDecoder);
        }
        ImmutableList handles = handleBuilder.build();
        ImmutableMap immutableMap = keyFieldDecoderBuilder.build();
        ImmutableMap valueFieldDecoders = valueFieldDecoderBuilder.build();
        return new RedisRecordSet(redisSplit, this.jedisManager, (List<DecoderColumnHandle>)handles, keyDecoder, valueDecoder, (Map<DecoderColumnHandle, FieldDecoder<?>>)immutableMap, (Map<DecoderColumnHandle, FieldDecoder<?>>)valueFieldDecoders);
    }
}

