/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Set;

public class RedisInternalFieldDescription {
    public static final RedisInternalFieldDescription KEY_FIELD = new RedisInternalFieldDescription("_key", (Type)VarcharType.createUnboundedVarcharType(), "Key text");
    public static final RedisInternalFieldDescription VALUE_FIELD = new RedisInternalFieldDescription("_value", (Type)VarcharType.createUnboundedVarcharType(), "Value text");
    public static final RedisInternalFieldDescription VALUE_CORRUPT_FIELD = new RedisInternalFieldDescription("_value_corrupt", (Type)BooleanType.BOOLEAN, "Value data is corrupt");
    public static final RedisInternalFieldDescription VALUE_LENGTH_FIELD = new RedisInternalFieldDescription("_value_length", (Type)BigintType.BIGINT, "Total number of value bytes");
    public static final RedisInternalFieldDescription KEY_CORRUPT_FIELD = new RedisInternalFieldDescription("_key_corrupt", (Type)BooleanType.BOOLEAN, "Key data is corrupt");
    public static final RedisInternalFieldDescription KEY_LENGTH_FIELD = new RedisInternalFieldDescription("_key_length", (Type)BigintType.BIGINT, "Total number of key bytes");
    private final String name;
    private final Type type;
    private final String comment;

    public static Set<RedisInternalFieldDescription> getInternalFields() {
        return ImmutableSet.of((Object)KEY_FIELD, (Object)VALUE_FIELD, (Object)KEY_LENGTH_FIELD, (Object)VALUE_LENGTH_FIELD, (Object)KEY_CORRUPT_FIELD, (Object)VALUE_CORRUPT_FIELD, (Object[])new RedisInternalFieldDescription[0]);
    }

    RedisInternalFieldDescription(String name, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    RedisColumnHandle getColumnHandle(String connectorId, int index, boolean hidden) {
        return new RedisColumnHandle(connectorId, index, this.getName(), this.getType(), null, null, null, false, hidden, true);
    }

    ColumnMetadata getColumnMetadata(boolean hidden) {
        return new ColumnMetadata(this.name, this.type, this.comment, hidden);
    }

    public FieldValueProvider forBooleanValue(boolean value) {
        return new BooleanRedisFieldValueProvider(value);
    }

    public FieldValueProvider forLongValue(long value) {
        return new LongRedisFieldValueProvider(value);
    }

    public FieldValueProvider forByteValue(byte[] value) {
        return new BytesRedisFieldValueProvider(value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RedisInternalFieldDescription other = (RedisInternalFieldDescription)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }

    public class BytesRedisFieldValueProvider
    extends FieldValueProvider {
        private final byte[] value;

        private BytesRedisFieldValueProvider(byte[] value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(RedisInternalFieldDescription.this.name);
        }

        public Slice getSlice() {
            return this.isNull() ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])this.value);
        }

        public boolean isNull() {
            return this.value == null || this.value.length == 0;
        }
    }

    public class LongRedisFieldValueProvider
    extends FieldValueProvider {
        private final long value;

        private LongRedisFieldValueProvider(long value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(RedisInternalFieldDescription.this.name);
        }

        public long getLong() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }
    }

    public class BooleanRedisFieldValueProvider
    extends FieldValueProvider {
        private final boolean value;

        private BooleanRedisFieldValueProvider(boolean value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(RedisInternalFieldDescription.this.name);
        }

        public boolean getBoolean() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }
    }
}

