/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnectorFactory;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorFactoryContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RedisPlugin
implements Plugin {
    private Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier = Optional.empty();
    private Map<String, String> optionalConfig = ImmutableMap.of();

    public synchronized void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf(Objects.requireNonNull(optionalConfig, "optionalConfig is null"));
    }

    @VisibleForTesting
    public synchronized void setTableDescriptionSupplier(Supplier<Map<SchemaTableName, RedisTableDescription>> tableDescriptionSupplier) {
        this.tableDescriptionSupplier = Optional.of(Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null"));
    }

    public synchronized Iterable<ConnectorFactory> getLegacyConnectorFactories(ConnectorFactoryContext context) {
        return ImmutableList.of((Object)new RedisConnectorFactory(context.getTypeManager(), context.getNodeManager(), this.tableDescriptionSupplier, this.optionalConfig));
    }
}

