/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.redis.RedisTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import redis.clients.jedis.Jedis;

public class RedisSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final RedisConnectorConfig redisConnectorConfig;
    private final RedisHandleResolver handleResolver;
    private final RedisJedisManager jedisManager;
    private static final long REDIS_MAX_SPLITS = 100L;
    private static final long REDIS_STRIDE_SPLITS = 100L;

    @Inject
    public RedisSplitManager(RedisConnectorId connectorId, RedisConnectorConfig redisConnectorConfig, RedisHandleResolver handleResolver, RedisJedisManager jedisManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.redisConnectorConfig = Objects.requireNonNull(redisConnectorConfig, "redisConfig is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorSession session, ConnectorTableLayoutHandle layout) {
        long stride;
        RedisTableHandle redisTableHandle = this.handleResolver.convertLayout(layout).getTable();
        ArrayList<HostAddress> nodes = new ArrayList<HostAddress>(this.redisConnectorConfig.getNodes());
        Collections.shuffle(nodes);
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Redis nodes available");
        ImmutableList.Builder builder = ImmutableList.builder();
        long numberOfKeys = 1L;
        if (redisTableHandle.getKeyDataFormat().equals("zset")) {
            try (Jedis jedis = this.jedisManager.getJedisPool((HostAddress)nodes.get(0)).getResource();){
                numberOfKeys = jedis.zcount(redisTableHandle.getKeyName(), "-inf", "+inf");
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (numberOfKeys / (stride = 100L) > 100L) {
            stride = numberOfKeys / 100L;
        }
        for (long startIndex = 0L; startIndex < numberOfKeys; startIndex += stride) {
            long endIndex = startIndex + stride - 1L;
            if (endIndex >= numberOfKeys) {
                endIndex = -1L;
            }
            RedisSplit split = new RedisSplit(this.connectorId, redisTableHandle.getSchemaName(), redisTableHandle.getTableName(), redisTableHandle.getKeyDataFormat(), redisTableHandle.getValueDataFormat(), redisTableHandle.getKeyName(), startIndex, endIndex, nodes);
            builder.add((Object)split);
        }
        return new FixedSplitSource(this.connectorId, (Iterable)builder.build());
    }
}

