/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.redis.RedisTableHandle;
import com.facebook.presto.redis.RedisTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class RedisHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    RedisHandleResolver(RedisConnectorId connectorId, RedisConnectorConfig redisConnectorConfig) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle != null && tableHandle instanceof RedisTableHandle && this.connectorId.equals(((RedisTableHandle)tableHandle).getConnectorId());
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle != null && columnHandle instanceof RedisColumnHandle && this.connectorId.equals(((RedisColumnHandle)columnHandle).getConnectorId());
    }

    public boolean canHandle(ConnectorSplit split) {
        return split != null && split instanceof RedisSplit && this.connectorId.equals(((RedisSplit)split).getConnectorId());
    }

    public boolean canHandle(ConnectorTableLayoutHandle handle) {
        return handle instanceof RedisTableLayoutHandle && ((RedisTableLayoutHandle)handle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return false;
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return RedisTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return RedisColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return RedisSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass() {
        return RedisTableLayoutHandle.class;
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    RedisTableHandle convertTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof RedisTableHandle), (Object)"tableHandle is not an instance of RedisTableHandle");
        RedisTableHandle redisTableHandle = (RedisTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)redisTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        return redisTableHandle;
    }

    RedisColumnHandle convertColumnHandle(ColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof RedisColumnHandle), (Object)"columnHandle is not an instance of RedisColumnHandle");
        RedisColumnHandle redisColumnHandle = (RedisColumnHandle)columnHandle;
        Preconditions.checkArgument((boolean)redisColumnHandle.getConnectorId().equals(this.connectorId), (Object)"columnHandle is not for this connector");
        return redisColumnHandle;
    }

    RedisSplit convertSplit(ConnectorSplit split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split instanceof RedisSplit), (Object)"split is not an instance of RedisSplit");
        RedisSplit redisSplit = (RedisSplit)split;
        Preconditions.checkArgument((boolean)redisSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        return redisSplit;
    }

    RedisTableLayoutHandle convertLayout(ConnectorTableLayoutHandle layout) {
        Objects.requireNonNull(layout, "layout is null");
        Preconditions.checkArgument((boolean)(layout instanceof RedisTableLayoutHandle), (Object)"layout is not an instance of RedisTableLayoutHandle");
        RedisTableLayoutHandle redisLayout = (RedisTableLayoutHandle)layout;
        Preconditions.checkArgument((boolean)redisLayout.getConnectorId().equals(this.connectorId), (Object)"layout is not for this connector");
        return redisLayout;
    }
}

