/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisConnector;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisConnectorModule;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.redis.RedisTableDescriptionSupplier;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RedisConnectorFactory
implements ConnectorFactory {
    private final TypeManager typeManager;
    private final NodeManager nodeManager;
    private final Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier;
    private final Map<String, String> optionalConfig;

    RedisConnectorFactory(TypeManager typeManager, NodeManager nodeManager, Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier, Map<String, String> optionalConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.optionalConfig = Objects.requireNonNull(optionalConfig, "optionalConfig is null");
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
    }

    public String getName() {
        return "redis";
    }

    public Connector create(String connectorId, Map<String, String> config) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new RedisConnectorModule(), binder -> {
                binder.bind(RedisConnectorId.class).toInstance((Object)new RedisConnectorId(connectorId));
                binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
                binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
                if (this.tableDescriptionSupplier.isPresent()) {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(){}).toInstance(this.tableDescriptionSupplier.get());
                } else {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(){}).to(RedisTableDescriptionSupplier.class).in(Scopes.SINGLETON);
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(RedisConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

