/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class RedisColumnHandle
implements DecoderColumnHandle,
Comparable<RedisColumnHandle> {
    private final String connectorId;
    private final int ordinalPosition;
    private final String name;
    private final Type type;
    private final String mapping;
    private final String dataFormat;
    private final String formatHint;
    private final boolean keyDecoder;
    private final boolean hidden;
    private final boolean internal;

    @JsonCreator
    public RedisColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="keyDecoder") boolean keyDecoder, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.ordinalPosition = ordinalPosition;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.mapping = mapping;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.keyDecoder = keyDecoder;
        this.hidden = hidden;
        this.internal = internal;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public boolean isKeyDecoder() {
        return this.keyDecoder;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.type, false, null, this.hidden);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.ordinalPosition, this.name, this.type, this.mapping, this.dataFormat, this.formatHint, this.keyDecoder, this.hidden, this.internal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RedisColumnHandle other = (RedisColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.ordinalPosition, other.ordinalPosition) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.dataFormat, other.dataFormat) && Objects.equals(this.formatHint, other.formatHint) && Objects.equals(this.keyDecoder, other.keyDecoder) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.internal, other.internal);
    }

    @Override
    public int compareTo(RedisColumnHandle otherHandle) {
        return Integer.compare(this.getOrdinalPosition(), otherHandle.getOrdinalPosition());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("ordinalPosition", this.ordinalPosition).add("name", (Object)this.name).add("type", (Object)this.type).add("mapping", (Object)this.mapping).add("dataFormat", (Object)this.dataFormat).add("formatHint", (Object)this.formatHint).add("keyDecoder", this.keyDecoder).add("hidden", this.hidden).add("internal", this.internal).toString();
    }
}

