/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisConnectorId;
import com.facebook.presto.redis.RedisHandleResolver;
import com.facebook.presto.redis.RedisInternalFieldDescription;
import com.facebook.presto.redis.RedisTableDescription;
import com.facebook.presto.redis.RedisTableFieldDescription;
import com.facebook.presto.redis.RedisTableFieldGroup;
import com.facebook.presto.redis.RedisTableHandle;
import com.facebook.presto.redis.RedisTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RedisMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(RedisMetadata.class);
    private final String connectorId;
    private final RedisConnectorConfig redisConnectorConfig;
    private final RedisHandleResolver handleResolver;
    private final Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier;
    private final Set<RedisInternalFieldDescription> internalFieldDescriptions;

    @Inject
    RedisMetadata(RedisConnectorId connectorId, RedisConnectorConfig redisConnectorConfig, RedisHandleResolver handleResolver, Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier, Set<RedisInternalFieldDescription> internalFieldDescriptions) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.redisConnectorConfig = Objects.requireNonNull(redisConnectorConfig, "redisConfig is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        log.debug("Loading redis table definitions from %s", new Object[]{redisConnectorConfig.getTableDescriptionDir().getAbsolutePath()});
        this.redisTableDescriptionSupplier = Suppliers.memoize(redisTableDescriptionSupplier);
        this.internalFieldDescriptions = Objects.requireNonNull(internalFieldDescriptions, "internalFieldDescriptions is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        Set schemas = this.getDefinedTables().keySet().stream().map(SchemaTableName::getSchemaName).collect(Collectors.toCollection(LinkedHashSet::new));
        return ImmutableList.copyOf((Collection)schemas);
    }

    public RedisTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        String keyName = null;
        if (table.getKey() != null) {
            keyName = table.getKey().getName();
        }
        return new RedisTableHandle(this.connectorId, schemaTableName.getSchemaName(), schemaTableName.getTableName(), RedisMetadata.getDataFormat(table.getKey()), RedisMetadata.getDataFormat(table.getValue()), keyName);
    }

    private static String getDataFormat(RedisTableFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RedisTableHandle redisTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        return this.getTableMetadata(redisTableHandle.toSchemaTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        RedisTableHandle tableHandle = this.handleResolver.convertTableHandle(table);
        Optional partitioningColumns = Optional.empty();
        ImmutableList localProperties = ImmutableList.of();
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new RedisTableLayoutHandle(tableHandle), Optional.empty(), TupleDomain.all(), partitioningColumns, Optional.empty(), (List)localProperties);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        RedisTableLayoutHandle layout = this.handleResolver.convertLayout(handle);
        return this.getTableLayouts(session, layout.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).get(0).getTableLayout();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            if (schemaNameOrNull != null && !tableName.getSchemaName().equals(schemaNameOrNull)) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<RedisTableFieldDescription> fields;
        RedisTableFieldGroup value;
        List<RedisTableFieldDescription> fields2;
        RedisTableHandle redisTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        RedisTableDescription redisTableDescription = this.getDefinedTables().get(redisTableHandle.toSchemaTableName());
        if (redisTableDescription == null) {
            throw new TableNotFoundException(redisTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        RedisTableFieldGroup key = redisTableDescription.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (RedisTableFieldDescription redisTableFieldDescription : fields2) {
                columnHandles.put((Object)redisTableFieldDescription.getName(), (Object)redisTableFieldDescription.getColumnHandle(this.connectorId, true, index++));
            }
        }
        if ((value = redisTableDescription.getValue()) != null && (fields = value.getFields()) != null) {
            for (RedisTableFieldDescription redisTableFieldDescription : fields) {
                columnHandles.put((Object)redisTableFieldDescription.getName(), (Object)redisTableFieldDescription.getColumnHandle(this.connectorId, false, index++));
            }
        }
        for (RedisInternalFieldDescription redisInternalFieldDescription : this.internalFieldDescriptions) {
            RedisColumnHandle columnHandle = redisInternalFieldDescription.getColumnHandle(this.connectorId, index++, this.redisConnectorConfig.isHideInternalColumns());
            columnHandles.put((Object)redisInternalFieldDescription.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getSchemaName() == null ? this.listTables(session, null) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        this.handleResolver.convertTableHandle(tableHandle);
        RedisColumnHandle redisColumnHandle = this.handleResolver.convertColumnHandle(columnHandle);
        return redisColumnHandle.getColumnMetadata();
    }

    @VisibleForTesting
    Map<SchemaTableName, RedisTableDescription> getDefinedTables() {
        return (Map)this.redisTableDescriptionSupplier.get();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        List<RedisTableFieldDescription> fields;
        RedisTableFieldGroup value;
        List<RedisTableFieldDescription> fields2;
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        RedisTableFieldGroup key = table.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (RedisTableFieldDescription redisTableFieldDescription : fields2) {
                builder.add((Object)redisTableFieldDescription.getColumnMetadata(index++));
            }
        }
        if ((value = table.getValue()) != null && (fields = value.getFields()) != null) {
            for (RedisTableFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata(index++));
            }
        }
        for (RedisInternalFieldDescription redisInternalFieldDescription : this.internalFieldDescriptions) {
            builder.add((Object)redisInternalFieldDescription.getColumnMetadata(index++, this.redisConnectorConfig.isHideInternalColumns()));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }
}

