/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.rcfile.ColumnEncoding;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.NoneCompressor;
import com.facebook.presto.rcfile.PageSplitterUtil;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileCompressor;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.RcFileDataSource;
import com.facebook.presto.rcfile.RcFileDecoderUtils;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.rcfile.RcFileWriteValidation;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RcFileWriter
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RcFileWriter.class).instanceSize();
    private static final Slice RCFILE_MAGIC = Slices.utf8Slice((String)"RCF");
    private static final int CURRENT_VERSION = 1;
    private static final String COLUMN_COUNT_METADATA_KEY = "hive.io.rcfile.column.number";
    private static final DataSize DEFAULT_TARGET_MIN_ROW_GROUP_SIZE = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_TARGET_MAX_ROW_GROUP_SIZE = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MIN_BUFFER_SIZE = new DataSize(4.0, DataSize.Unit.KILOBYTE);
    private static final DataSize MAX_BUFFER_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    static final String PRESTO_RCFILE_WRITER_VERSION_METADATA_KEY = "presto.writer.version";
    static final String PRESTO_RCFILE_WRITER_VERSION;
    private final SliceOutput output;
    private final List<Type> types;
    private final RcFileEncoding encoding;
    private final RcFileCodecFactory codecFactory;
    private final long syncFirst = ThreadLocalRandom.current().nextLong();
    private final long syncSecond = ThreadLocalRandom.current().nextLong();
    private RcFileCompressor.CompressedSliceOutput keySectionOutput;
    private final ColumnEncoder[] columnEncoders;
    private final int targetMinRowGroupSize;
    private final int targetMaxRowGroupSize;
    private int bufferedSize;
    private int bufferedRows;
    private long totalRowCount;
    @Nullable
    private final RcFileWriteValidation.RcFileWriteValidationBuilder validationBuilder;

    public RcFileWriter(SliceOutput output, List<Type> types, RcFileEncoding encoding, Optional<String> codecName, RcFileCodecFactory codecFactory, Map<String, String> metadata, boolean validate) throws IOException {
        this(output, types, encoding, codecName, codecFactory, metadata, DEFAULT_TARGET_MIN_ROW_GROUP_SIZE, DEFAULT_TARGET_MAX_ROW_GROUP_SIZE, validate);
    }

    public RcFileWriter(SliceOutput output, List<Type> types, RcFileEncoding encoding, Optional<String> codecName, RcFileCodecFactory codecFactory, Map<String, String> metadata, DataSize targetMinRowGroupSize, DataSize targetMaxRowGroupSize, boolean validate) throws IOException {
        Objects.requireNonNull(output, "output is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        Objects.requireNonNull(encoding, "encoding is null");
        Objects.requireNonNull(codecName, "codecName is null");
        Objects.requireNonNull(codecFactory, "codecFactory is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Preconditions.checkArgument((!metadata.containsKey(PRESTO_RCFILE_WRITER_VERSION_METADATA_KEY) ? 1 : 0) != 0, (String)"Cannot set property %s", (Object)PRESTO_RCFILE_WRITER_VERSION_METADATA_KEY);
        Preconditions.checkArgument((!metadata.containsKey(COLUMN_COUNT_METADATA_KEY) ? 1 : 0) != 0, (String)"Cannot set property %s", (Object)COLUMN_COUNT_METADATA_KEY);
        Objects.requireNonNull(targetMinRowGroupSize, "targetMinRowGroupSize is null");
        Objects.requireNonNull(targetMaxRowGroupSize, "targetMaxRowGroupSize is null");
        Preconditions.checkArgument((targetMinRowGroupSize.compareTo(targetMaxRowGroupSize) <= 0 ? 1 : 0) != 0, (Object)"targetMinRowGroupSize must be less than or equal to targetMaxRowGroupSize");
        this.validationBuilder = validate ? new RcFileWriteValidation.RcFileWriteValidationBuilder(types) : null;
        this.output = output;
        this.types = types;
        this.encoding = encoding;
        this.codecFactory = codecFactory;
        output.writeBytes(RCFILE_MAGIC);
        output.writeByte(1);
        this.recordValidation(validation -> validation.setVersion((byte)1));
        output.writeBoolean(codecName.isPresent());
        codecName.ifPresent(name -> RcFileDecoderUtils.writeLengthPrefixedString(output, Slices.utf8Slice((String)name)));
        this.recordValidation(validation -> validation.setCodecClassName(codecName));
        output.writeInt(Integer.reverseBytes(metadata.size() + 2));
        this.writeMetadataProperty(COLUMN_COUNT_METADATA_KEY, Integer.toString(types.size()));
        this.writeMetadataProperty(PRESTO_RCFILE_WRITER_VERSION_METADATA_KEY, PRESTO_RCFILE_WRITER_VERSION);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.writeMetadataProperty(entry.getKey(), entry.getValue());
        }
        output.writeLong(this.syncFirst);
        this.recordValidation(validation -> validation.setSyncFirst(this.syncFirst));
        output.writeLong(this.syncSecond);
        this.recordValidation(validation -> validation.setSyncSecond(this.syncSecond));
        RcFileCompressor compressor = codecName.map(codecFactory::createCompressor).orElse(new NoneCompressor());
        this.keySectionOutput = compressor.createCompressedSliceOutput((int)MIN_BUFFER_SIZE.toBytes(), (int)MAX_BUFFER_SIZE.toBytes());
        this.keySectionOutput.close();
        this.columnEncoders = new ColumnEncoder[types.size()];
        for (int columnIndex = 0; columnIndex < types.size(); ++columnIndex) {
            Type type = types.get(columnIndex);
            ColumnEncoding columnEncoding = encoding.getEncoding(type);
            this.columnEncoders[columnIndex] = new ColumnEncoder(columnEncoding, compressor);
        }
        this.targetMinRowGroupSize = StrictMath.toIntExact(targetMinRowGroupSize.toBytes());
        this.targetMaxRowGroupSize = StrictMath.toIntExact(targetMaxRowGroupSize.toBytes());
    }

    private void writeMetadataProperty(String key, String value) {
        RcFileDecoderUtils.writeLengthPrefixedString(this.output, Slices.utf8Slice((String)key));
        RcFileDecoderUtils.writeLengthPrefixedString(this.output, Slices.utf8Slice((String)value));
        this.recordValidation(validation -> validation.addMetadataProperty(key, value));
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.output);
            closer.register(this.keySectionOutput::destroy);
            for (ColumnEncoder columnEncoder : this.columnEncoders) {
                closer.register(columnEncoder::destroy);
            }
            this.writeRowGroup();
        }
    }

    private void recordValidation(Consumer<RcFileWriteValidation.RcFileWriteValidationBuilder> task) {
        if (this.validationBuilder != null) {
            task.accept(this.validationBuilder);
        }
    }

    public void validate(RcFileDataSource input) throws RcFileCorruptionException {
        Preconditions.checkState((this.validationBuilder != null ? 1 : 0) != 0, (Object)"validation is not enabled");
        RcFileReader.validateFile(this.validationBuilder.build(), input, this.encoding, this.types, this.codecFactory);
    }

    public long getRetainedSizeInBytes() {
        long retainedSize = INSTANCE_SIZE;
        retainedSize += this.output.getRetainedSize();
        retainedSize += this.keySectionOutput.getRetainedSize();
        for (ColumnEncoder columnEncoder : this.columnEncoders) {
            retainedSize += columnEncoder.getRetainedSizeInBytes();
        }
        return retainedSize;
    }

    public void write(Page page) throws IOException {
        if (page.getPositionCount() == 0) {
            return;
        }
        List<Page> pages = PageSplitterUtil.splitPage(page, this.targetMaxRowGroupSize);
        for (Page splitPage : pages) {
            this.bufferPage(splitPage);
        }
    }

    private void bufferPage(Page page) throws IOException {
        this.bufferedRows += page.getPositionCount();
        this.bufferedSize = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            this.columnEncoders[i].writeBlock(block);
            this.bufferedSize += this.columnEncoders[i].getBufferedSize();
        }
        this.recordValidation(validation -> validation.addPage(page));
        if (this.bufferedSize >= this.targetMinRowGroupSize) {
            this.writeRowGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRowGroup() throws IOException {
        if (this.bufferedRows == 0) {
            return;
        }
        if (this.totalRowCount != 0L) {
            this.output.writeInt(-1);
            this.output.writeLong(this.syncFirst);
            this.output.writeLong(this.syncSecond);
        }
        for (ColumnEncoder columnEncoder : this.columnEncoders) {
            columnEncoder.closeColumn();
        }
        int valueLength = 0;
        this.keySectionOutput = this.keySectionOutput.createRecycledCompressedSliceOutput();
        try {
            RcFileDecoderUtils.writeVInt(this.keySectionOutput, this.bufferedRows);
            this.recordValidation(validation -> validation.addRowGroup(this.bufferedRows));
            for (ColumnEncoder columnEncoder : this.columnEncoders) {
                valueLength += columnEncoder.getCompressedSize();
                RcFileDecoderUtils.writeVInt(this.keySectionOutput, columnEncoder.getCompressedSize());
                RcFileDecoderUtils.writeVInt(this.keySectionOutput, columnEncoder.getUncompressedSize());
                Slice lengthData = columnEncoder.getLengthData();
                RcFileDecoderUtils.writeVInt(this.keySectionOutput, lengthData.length());
                this.keySectionOutput.writeBytes(lengthData);
            }
        }
        finally {
            this.keySectionOutput.close();
        }
        this.output.writeInt(Integer.reverseBytes(this.keySectionOutput.size() + valueLength));
        this.output.writeInt(Integer.reverseBytes(this.keySectionOutput.size()));
        this.output.writeInt(Integer.reverseBytes(this.keySectionOutput.getCompressedSize()));
        for (Slice slice : this.keySectionOutput.getCompressedSlices()) {
            this.output.writeBytes(slice);
        }
        for (ColumnEncoder columnEncoder : this.columnEncoders) {
            List<Slice> slices = columnEncoder.getCompressedData();
            for (Slice slice : slices) {
                this.output.writeBytes(slice);
            }
            columnEncoder.reset();
        }
        this.totalRowCount += (long)this.bufferedRows;
        this.bufferedSize = 0;
        this.bufferedRows = 0;
    }

    static {
        String version = RcFileWriter.class.getPackage().getImplementationVersion();
        PRESTO_RCFILE_WRITER_VERSION = version == null ? "UNKNOWN" : version;
    }

    private static class ColumnEncoder {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(ColumnEncoder.class).instanceSize() + ClassLayout.parseClass(ColumnEncodeOutput.class).instanceSize();
        private final ColumnEncoding columnEncoding;
        private ColumnEncodeOutput encodeOutput;
        private final SliceOutput lengthOutput = new DynamicSliceOutput(512);
        private RcFileCompressor.CompressedSliceOutput output;
        private boolean columnClosed;

        public ColumnEncoder(ColumnEncoding columnEncoding, RcFileCompressor compressor) {
            this.columnEncoding = columnEncoding;
            this.output = compressor.createCompressedSliceOutput((int)MIN_BUFFER_SIZE.toBytes(), (int)MAX_BUFFER_SIZE.toBytes());
            this.encodeOutput = new ColumnEncodeOutput(this.lengthOutput, this.output);
        }

        private void writeBlock(Block block) throws IOException {
            Preconditions.checkArgument((!this.columnClosed ? 1 : 0) != 0, (Object)"Column is closed");
            this.columnEncoding.encodeColumn(block, this.output, this.encodeOutput);
        }

        public void closeColumn() throws IOException {
            Preconditions.checkArgument((!this.columnClosed ? 1 : 0) != 0, (Object)"Column is not open");
            this.encodeOutput.flush();
            this.output.close();
            this.columnClosed = true;
        }

        public int getBufferedSize() {
            return this.lengthOutput.size() + this.output.size();
        }

        public Slice getLengthData() {
            Preconditions.checkArgument((boolean)this.columnClosed, (Object)"Column is open");
            return this.lengthOutput.slice();
        }

        public int getUncompressedSize() {
            Preconditions.checkArgument((boolean)this.columnClosed, (Object)"Column is open");
            return this.output.size();
        }

        public int getCompressedSize() {
            Preconditions.checkArgument((boolean)this.columnClosed, (Object)"Column is open");
            return this.output.getCompressedSize();
        }

        public List<Slice> getCompressedData() {
            Preconditions.checkArgument((boolean)this.columnClosed, (Object)"Column is open");
            return this.output.getCompressedSlices();
        }

        public void reset() {
            Preconditions.checkArgument((boolean)this.columnClosed, (Object)"Column is open");
            this.lengthOutput.reset();
            this.output = this.output.createRecycledCompressedSliceOutput();
            this.encodeOutput = new ColumnEncodeOutput(this.lengthOutput, this.output);
            this.columnClosed = false;
        }

        public void destroy() throws IOException {
            this.output.destroy();
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.lengthOutput.getRetainedSize() + this.output.getRetainedSize();
        }

        private static class ColumnEncodeOutput
        implements EncodeOutput {
            private final SliceOutput lengthOutput;
            private final SliceOutput valueOutput;
            private int previousOffset;
            private int previousLength;
            private int runLength;

            public ColumnEncodeOutput(SliceOutput lengthOutput, SliceOutput valueOutput) {
                this.lengthOutput = lengthOutput;
                this.valueOutput = valueOutput;
                this.previousOffset = valueOutput.size();
                this.previousLength = -1;
            }

            @Override
            public void closeEntry() {
                int offset = this.valueOutput.size();
                int length = offset - this.previousOffset;
                this.previousOffset = offset;
                if (length == this.previousLength) {
                    ++this.runLength;
                } else {
                    if (this.runLength > 0) {
                        int value = ~this.runLength;
                        RcFileDecoderUtils.writeVInt(this.lengthOutput, value);
                    }
                    RcFileDecoderUtils.writeVInt(this.lengthOutput, length);
                    this.previousLength = length;
                    this.runLength = 0;
                }
            }

            private void flush() {
                if (this.runLength > 0) {
                    int value = ~this.runLength;
                    RcFileDecoderUtils.writeVInt(this.lengthOutput, value);
                }
                this.previousLength = -1;
                this.runLength = 0;
            }
        }
    }
}

