/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.rcfile.HadoopCompressor;
import com.facebook.presto.rcfile.HadoopDecompressor;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileCompressor;
import com.facebook.presto.rcfile.RcFileDecompressor;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;

public class HadoopCodecFactory
implements RcFileCodecFactory {
    private final ClassLoader classLoader;

    public HadoopCodecFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public RcFileCompressor createCompressor(String codecName) {
        CompressionCodec codec = this.createCompressionCodec(codecName);
        return new HadoopCompressor(codec);
    }

    @Override
    public RcFileDecompressor createDecompressor(String codecName) {
        CompressionCodec codec = this.createCompressionCodec(codecName);
        return new HadoopDecompressor(codec);
    }

    private CompressionCodec createCompressionCodec(String codecName) {
        try {
            Class<CompressionCodec> codecClass = this.classLoader.loadClass(codecName).asSubclass(CompressionCodec.class);
            Constructor<CompressionCodec> constructor = codecClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            CompressionCodec codec = constructor.newInstance(new Object[0]);
            if (codec instanceof Configurable) {
                ((Configurable)codec).setConf(new Configuration(false));
            }
            return codec;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unknown codec: " + codecName, e);
        }
    }
}

