/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class FloatEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public FloatEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                float value = Float.intBitsToFloat((int)this.type.getLong(block, position));
                this.buffer.setLength(0);
                this.buffer.append(value);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        float value = Float.intBitsToFloat((int)this.type.getLong(block, position));
        this.buffer.setLength(0);
        this.buffer.append(value);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) throws RcFileCorruptionException {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, (long)Float.floatToIntBits(FloatEncoding.parseFloat(slice, offset, length)));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        this.type.writeLong(builder, (long)Float.floatToIntBits(FloatEncoding.parseFloat(slice, offset, length)));
    }

    private static float parseFloat(Slice slice, int start, int length) throws RcFileCorruptionException {
        try {
            return Float.parseFloat(slice.toStringAscii(start, length));
        }
        catch (NumberFormatException e) {
            throw new RcFileCorruptionException(e, "Invalid float value", new Object[0]);
        }
    }
}

