/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.binary;

import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.binary.BinaryColumnEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class DoubleEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public DoubleEncoding(Type type) {
        this.type = type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                this.encodeValueInto(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        output.writeLong(Long.reverseBytes(Double.doubleToLongBits(this.type.getDouble(block, position))));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                Preconditions.checkState((length == 8 ? 1 : 0) != 0, (Object)"Double should be 8 bytes");
                long longBits = slice.getLong(columnData.getOffset(i));
                this.type.writeDouble(builder, Double.longBitsToDouble(Long.reverseBytes(longBits)));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return 8;
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        long longBits = slice.getLong(offset);
        double value = Double.longBitsToDouble(Long.reverseBytes(longBits));
        this.type.writeDouble(builder, value);
    }
}

