/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.binary;

import com.facebook.presto.rcfile.ColumnEncoding;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.binary.BinaryColumnEncoding;
import com.facebook.presto.rcfile.binary.BinaryEncoding;
import com.facebook.presto.rcfile.binary.BooleanEncoding;
import com.facebook.presto.rcfile.binary.ByteEncoding;
import com.facebook.presto.rcfile.binary.DateEncoding;
import com.facebook.presto.rcfile.binary.DecimalEncoding;
import com.facebook.presto.rcfile.binary.DoubleEncoding;
import com.facebook.presto.rcfile.binary.FloatEncoding;
import com.facebook.presto.rcfile.binary.ListEncoding;
import com.facebook.presto.rcfile.binary.LongEncoding;
import com.facebook.presto.rcfile.binary.MapEncoding;
import com.facebook.presto.rcfile.binary.ShortEncoding;
import com.facebook.presto.rcfile.binary.StringEncoding;
import com.facebook.presto.rcfile.binary.StructEncoding;
import com.facebook.presto.rcfile.binary.TimestampEncoding;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.stream.Collectors;

public class BinaryRcFileEncoding
implements RcFileEncoding {
    @Override
    public ColumnEncoding booleanEncoding(Type type) {
        return new BooleanEncoding(type);
    }

    @Override
    public ColumnEncoding byteEncoding(Type type) {
        return new ByteEncoding(type);
    }

    @Override
    public ColumnEncoding shortEncoding(Type type) {
        return new ShortEncoding(type);
    }

    @Override
    public ColumnEncoding intEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding longEncoding(Type type) {
        return new LongEncoding(type);
    }

    @Override
    public ColumnEncoding decimalEncoding(Type type) {
        if (Decimals.isShortDecimal((Type)type)) {
            return new DecimalEncoding(type);
        }
        if (Decimals.isLongDecimal((Type)type)) {
            return new DecimalEncoding(type);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    public ColumnEncoding floatEncoding(Type type) {
        return new FloatEncoding(type);
    }

    @Override
    public ColumnEncoding doubleEncoding(Type type) {
        return new DoubleEncoding(type);
    }

    @Override
    public ColumnEncoding stringEncoding(Type type) {
        return new StringEncoding(type);
    }

    @Override
    public ColumnEncoding binaryEncoding(Type type) {
        return new BinaryEncoding(type);
    }

    @Override
    public ColumnEncoding dateEncoding(Type type) {
        return new DateEncoding(type);
    }

    @Override
    public ColumnEncoding timestampEncoding(Type type) {
        return new TimestampEncoding(type);
    }

    @Override
    public ColumnEncoding listEncoding(Type type, ColumnEncoding elementEncoding) {
        return new ListEncoding(type, (BinaryColumnEncoding)elementEncoding);
    }

    @Override
    public ColumnEncoding mapEncoding(Type type, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding) {
        return new MapEncoding(type, (BinaryColumnEncoding)keyEncoding, (BinaryColumnEncoding)valueEncoding);
    }

    @Override
    public ColumnEncoding structEncoding(Type type, List<ColumnEncoding> fieldEncodings) {
        return new StructEncoding(type, fieldEncodings.stream().map(field -> (BinaryColumnEncoding)field).collect(Collectors.toList()));
    }
}

