/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.rcfile.ChunkedSliceOutput;
import com.facebook.presto.rcfile.RcFileCompressor;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;

public class HadoopCompressor
implements RcFileCompressor {
    private final CompressionCodec codec;

    public HadoopCompressor(CompressionCodec codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    @Override
    public RcFileCompressor.CompressedSliceOutput createCompressedSliceOutput(int minChunkSize, int maxChunkSize) {
        return new HadoopCompressedSliceOutputSupplier(this.codec, minChunkSize, maxChunkSize).get();
    }

    private static class HadoopCompressedSliceOutputSupplier
    implements Supplier<RcFileCompressor.CompressedSliceOutput> {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ChunkedSliceOutput bufferedOutput;

        public HadoopCompressedSliceOutputSupplier(CompressionCodec codec, int minChunkSize, int maxChunkSize) {
            this.codec = Objects.requireNonNull(codec, "codec is null");
            this.compressor = CodecPool.getCompressor((CompressionCodec)Objects.requireNonNull(codec, "codec is null"));
            this.bufferedOutput = new ChunkedSliceOutput(minChunkSize, maxChunkSize);
        }

        @Override
        public RcFileCompressor.CompressedSliceOutput get() {
            try {
                this.compressor.reset();
                this.bufferedOutput.reset();
                CompressionOutputStream compressionStream = this.codec.createOutputStream((OutputStream)((Object)this.bufferedOutput), this.compressor);
                return new RcFileCompressor.CompressedSliceOutput((OutputStream)compressionStream, this.bufferedOutput, this, () -> CodecPool.returnCompressor((Compressor)this.compressor));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

