/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public final class ChunkedSliceOutput
extends SliceOutput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ChunkedSliceOutput.class).instanceSize();
    private static final int MINIMUM_CHUNK_SIZE = 4096;
    private static final int MAXIMUM_CHUNK_SIZE = 0x1000000;
    private static final int MAX_UNUSED_BUFFER_SIZE = 128;
    private final ChunkSupplier chunkSupplier;
    private Slice slice;
    private byte[] buffer;
    private final List<Slice> closedSlices = new ArrayList<Slice>();
    private long closedSlicesRetainedSize;
    private long streamOffset;
    private int bufferPosition;

    public ChunkedSliceOutput(int minChunkSize, int maxChunkSize) {
        this.chunkSupplier = new ChunkSupplier(minChunkSize, maxChunkSize);
        this.buffer = this.chunkSupplier.get();
        this.slice = Slices.wrappedBuffer((byte[])this.buffer);
    }

    public List<Slice> getSlices() {
        return ImmutableList.builder().addAll(this.closedSlices).add((Object)Slices.copyOf((Slice)this.slice, (int)0, (int)this.bufferPosition)).build();
    }

    public void reset() {
        this.chunkSupplier.reset();
        this.closedSlices.clear();
        this.buffer = this.chunkSupplier.get();
        this.slice = Slices.wrappedBuffer((byte[])this.buffer);
        this.closedSlicesRetainedSize = 0L;
        this.streamOffset = 0L;
        this.bufferPosition = 0;
    }

    public void reset(int position) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return Math.toIntExact(this.streamOffset + (long)this.bufferPosition);
    }

    public int getRetainedSize() {
        return Math.toIntExact((long)this.slice.getRetainedSize() + this.closedSlicesRetainedSize + (long)INSTANCE_SIZE);
    }

    public int writableBytes() {
        return Integer.MAX_VALUE;
    }

    public boolean isWritable() {
        return true;
    }

    public void writeByte(int value) {
        this.ensureWritableBytes(1);
        this.slice.setByte(this.bufferPosition, value);
        ++this.bufferPosition;
    }

    public void writeShort(int value) {
        this.ensureWritableBytes(2);
        this.slice.setShort(this.bufferPosition, value);
        this.bufferPosition += 2;
    }

    public void writeInt(int value) {
        this.ensureWritableBytes(4);
        this.slice.setInt(this.bufferPosition, value);
        this.bufferPosition += 4;
    }

    public void writeLong(long value) {
        this.ensureWritableBytes(8);
        this.slice.setLong(this.bufferPosition, value);
        this.bufferPosition += 8;
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    public void writeBytes(Slice source, int sourceIndex, int length) {
        while (length > 0) {
            int batch = this.tryEnsureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, batch);
            this.bufferPosition += batch;
            sourceIndex += batch;
            length -= batch;
        }
    }

    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    public void writeBytes(byte[] source, int sourceIndex, int length) {
        while (length > 0) {
            int batch = this.tryEnsureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, batch);
            this.bufferPosition += batch;
            sourceIndex += batch;
            length -= batch;
        }
    }

    public void writeBytes(InputStream in, int length) throws IOException {
        while (length > 0) {
            int batch = this.tryEnsureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, in, batch);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public void writeZero(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be greater than or equal to 0");
        while (length > 0) {
            int batch = this.tryEnsureBatchSize(length);
            Arrays.fill(this.buffer, this.bufferPosition, this.bufferPosition + batch, (byte)0);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    public SliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    public SliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    public SliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    public SliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    public SliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
        return this;
    }

    public SliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    public SliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    public Slice slice() {
        throw new UnsupportedOperationException();
    }

    public Slice getUnderlyingSlice() {
        throw new UnsupportedOperationException();
    }

    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OutputStreamSliceOutputAdapter{");
        builder.append("position=").append(this.size());
        builder.append("bufferSize=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    private int tryEnsureBatchSize(int length) {
        this.ensureWritableBytes(Math.min(128, length));
        return Math.min(length, this.slice.length() - this.bufferPosition);
    }

    private void ensureWritableBytes(int minWritableBytes) {
        Preconditions.checkArgument((minWritableBytes <= 128 ? 1 : 0) != 0);
        if (this.bufferPosition + minWritableBytes > this.slice.length()) {
            this.closeChunk();
        }
    }

    private void closeChunk() {
        this.closedSlices.add(this.slice.slice(0, this.bufferPosition));
        this.buffer = this.chunkSupplier.get();
        this.slice = Slices.wrappedBuffer((byte[])this.buffer);
        this.streamOffset += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private static class ChunkSupplier {
        private final int maxChunkSize;
        private final List<byte[]> bufferPool = new ArrayList<byte[]>();
        private final List<byte[]> usedBuffers = new ArrayList<byte[]>();
        private int currentSize;

        public ChunkSupplier(int minChunkSize, int maxChunkSize) {
            Preconditions.checkArgument((minChunkSize >= 4096 ? 1 : 0) != 0, (Object)"minimum chunk size of 4096 required");
            Preconditions.checkArgument((maxChunkSize <= 0x1000000 ? 1 : 0) != 0, (Object)"maximum chunk size of 16777216 required");
            Preconditions.checkArgument((minChunkSize <= maxChunkSize ? 1 : 0) != 0, (Object)"minimum chunk size must be less than maximum chunk size");
            this.currentSize = minChunkSize;
            this.maxChunkSize = maxChunkSize;
        }

        public void reset() {
            this.bufferPool.addAll(0, this.usedBuffers);
            this.usedBuffers.clear();
        }

        public byte[] get() {
            byte[] buffer;
            if (this.bufferPool.isEmpty()) {
                this.currentSize = Math.min(Math.multiplyExact(this.currentSize, 2), this.maxChunkSize);
                buffer = new byte[this.currentSize];
            } else {
                buffer = this.bufferPool.remove(0);
                this.currentSize = buffer.length;
            }
            this.usedBuffers.add(buffer);
            return buffer;
        }
    }
}

