/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.rcfile.BufferedOutputStreamSliceOutput;
import com.facebook.presto.rcfile.ChunkedSliceOutput;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public interface RcFileCompressor {
    public CompressedSliceOutput createCompressedSliceOutput(int var1, int var2);

    public static final class CompressedSliceOutput
    extends BufferedOutputStreamSliceOutput {
        private final ChunkedSliceOutput bufferedOutput;
        private final Supplier<CompressedSliceOutput> resetFactory;
        private final Runnable onDestroy;
        private boolean closed;
        private boolean destroyed;

        public CompressedSliceOutput(OutputStream compressionStream, ChunkedSliceOutput bufferedOutput, Supplier<CompressedSliceOutput> resetFactory, Runnable onDestroy) {
            super(compressionStream, 4096);
            this.bufferedOutput = Objects.requireNonNull(bufferedOutput, "bufferedOutput is null");
            this.resetFactory = Objects.requireNonNull(resetFactory, "resetFactory is null");
            this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy is null");
        }

        @Override
        public int getRetainedSize() {
            return super.getRetainedSize() + this.bufferedOutput.getRetainedSize();
        }

        public int getCompressedSize() {
            Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
            Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
            return this.bufferedOutput.size();
        }

        public List<Slice> getCompressedSlices() {
            Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
            Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
            return this.bufferedOutput.getSlices();
        }

        public CompressedSliceOutput createRecycledCompressedSliceOutput() {
            Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
            Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
            this.destroyed = true;
            return this.resetFactory.get();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public void destroy() {
            if (!this.destroyed) {
                this.destroyed = true;
                this.onDestroy.run();
            }
        }
    }
}

