/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.proxy;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class ProxyConfig {
    private URI uri;
    private File sharedSecretFile;
    private Duration asyncTimeout = new Duration(2.0, TimeUnit.MINUTES);

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Config(value="proxy.uri")
    @ConfigDescription(value="URI of the remote Presto server")
    public ProxyConfig setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    public File getSharedSecretFile() {
        return this.sharedSecretFile;
    }

    @Config(value="proxy.shared-secret-file")
    @ConfigDescription(value="Shared secret file used for authenticating URIs")
    public ProxyConfig setSharedSecretFile(File sharedSecretFile) {
        this.sharedSecretFile = sharedSecretFile;
        return this;
    }

    @NotNull
    public Duration getAsyncTimeout() {
        return this.asyncTimeout;
    }

    @Config(value="proxy.async-timeout")
    @ConfigDescription(value="Timeout for reading responses from Coordinator to Proxy")
    public ProxyConfig setAsyncTimeout(Duration asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
        return this;
    }
}

