/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.proxy;

import com.facebook.airlift.security.pem.PemReader;
import com.facebook.presto.proxy.JwtHandlerConfig;
import com.google.common.base.Preconditions;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;

public class JsonWebTokenHandler {
    private final Optional<Consumer<JwtBuilder>> jwtSigner;
    private final Optional<String> jwtKeyId;
    private final Optional<String> jwtIssuer;
    private final Optional<String> jwtAudience;

    @Inject
    public JsonWebTokenHandler(JwtHandlerConfig config) {
        this.jwtSigner = JsonWebTokenHandler.setupJwtSigner(config.getJwtKeyFile(), config.getJwtKeyFilePassword());
        this.jwtKeyId = Optional.ofNullable(config.getJwtKeyId());
        this.jwtIssuer = Optional.ofNullable(config.getJwtIssuer());
        this.jwtAudience = Optional.ofNullable(config.getJwtAudience());
    }

    public boolean isConfigured() {
        return this.jwtSigner.isPresent();
    }

    public String getBearerToken(String subject) {
        Preconditions.checkState((boolean)this.jwtSigner.isPresent(), (Object)"not configured");
        JwtBuilder jwt = Jwts.builder().setSubject(subject).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant()));
        this.jwtSigner.get().accept(jwt);
        this.jwtKeyId.ifPresent(keyId -> jwt.setHeaderParam("kid", keyId));
        this.jwtIssuer.ifPresent(arg_0 -> ((JwtBuilder)jwt).setIssuer(arg_0));
        this.jwtAudience.ifPresent(arg_0 -> ((JwtBuilder)jwt).setAudience(arg_0));
        return jwt.compact();
    }

    private static Optional<Consumer<JwtBuilder>> setupJwtSigner(File file, String password) {
        if (file == null) {
            return Optional.empty();
        }
        try {
            PrivateKey key = PemReader.loadPrivateKey((File)file, Optional.ofNullable(password));
            if (!(key instanceof RSAPrivateKey)) {
                throw new IOException("Only RSA private keys are supported");
            }
            return Optional.of(jwt -> jwt.signWith(SignatureAlgorithm.RS256, (Key)key));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load key file: " + file, e);
        }
        catch (GeneralSecurityException e) {
            try {
                byte[] base64Key = Files.readAllBytes(file.toPath());
                byte[] key = Base64.getMimeDecoder().decode(base64Key);
                return Optional.of(jwt -> jwt.signWith(SignatureAlgorithm.HS256, key));
            }
            catch (IOException | IllegalArgumentException e2) {
                throw new RuntimeException("Failed to load key file: " + file, e2);
            }
        }
    }
}

