/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.proxy;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import java.io.File;
import java.net.URI;
import javax.validation.constraints.NotNull;

public class ProxyConfig {
    private URI uri;
    private File sharedSecretFile;
    private File jwtKeyFile;
    private String jwtKeyFilePassword;
    private String jwtKeyId;
    private String jwtIssuer;
    private String jwtAudience;

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Config(value="proxy.uri")
    @ConfigDescription(value="URI of the remote Presto server")
    public ProxyConfig setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    public File getSharedSecretFile() {
        return this.sharedSecretFile;
    }

    @Config(value="proxy.shared-secret-file")
    @ConfigDescription(value="Shared secret file used for authenticating URIs")
    public ProxyConfig setSharedSecretFile(File sharedSecretFile) {
        this.sharedSecretFile = sharedSecretFile;
        return this;
    }

    public File getJwtKeyFile() {
        return this.jwtKeyFile;
    }

    @Config(value="proxy.jwt.key-file")
    @ConfigDescription(value="Key file used for generating JWT signatures")
    public ProxyConfig setJwtKeyFile(File jwtKeyFile) {
        this.jwtKeyFile = jwtKeyFile;
        return this;
    }

    public String getJwtKeyFilePassword() {
        return this.jwtKeyFilePassword;
    }

    @Config(value="proxy.jwt.key-file-password")
    @ConfigDescription(value="Password for encrypted key file")
    @ConfigSecuritySensitive
    public ProxyConfig setJwtKeyFilePassword(String jwtKeyFilePassword) {
        this.jwtKeyFilePassword = jwtKeyFilePassword;
        return this;
    }

    public String getJwtKeyId() {
        return this.jwtKeyId;
    }

    @Config(value="proxy.jwt.key-id")
    @ConfigDescription(value="Key ID for JWT")
    public ProxyConfig setJwtKeyId(String jwtKeyId) {
        this.jwtKeyId = jwtKeyId;
        return this;
    }

    public String getJwtIssuer() {
        return this.jwtIssuer;
    }

    @Config(value="proxy.jwt.issuer")
    @ConfigDescription(value="Issuer for JWT")
    public ProxyConfig setJwtIssuer(String jwtIssuer) {
        this.jwtIssuer = jwtIssuer;
        return this;
    }

    public String getJwtAudience() {
        return this.jwtAudience;
    }

    @Config(value="proxy.jwt.audience")
    @ConfigDescription(value="Audience for JWT")
    public ProxyConfig setJwtAudience(String jwtAudience) {
        this.jwtAudience = jwtAudience;
        return this;
    }
}

