/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.prometheus.PrometheusColumn;
import com.facebook.presto.plugin.prometheus.PrometheusConnectorConfig;
import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.plugin.prometheus.PrometheusTable;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PrometheusClient {
    public static final String METRICS_ENDPOINT = "/api/v1/label/__name__/values";
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().build();
    private final Optional<File> bearerTokenFile;
    private final Supplier<Map<String, Object>> tableSupplier;
    private final Type varcharMapType;
    private PrometheusConnectorConfig config;
    private static final Logger log = Logger.get(PrometheusClient.class);

    @Inject
    public PrometheusClient(PrometheusConnectorConfig config, JsonCodec<Map<String, Object>> metricCodec, TypeManager typeManager) {
        this.config = Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(metricCodec, "metricCodec is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.bearerTokenFile = config.getBearerTokenFile();
        URI prometheusMetricsUri = PrometheusClient.getPrometheusMetricsURI(config.getPrometheusURI());
        this.tableSupplier = Suppliers.memoizeWithExpiration(() -> this.fetchMetrics(metricCodec, prometheusMetricsUri), (long)config.getCacheDuration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.varcharMapType = typeManager.getType(PrometheusColumn.mapType(VarcharType.VARCHAR.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()));
    }

    private static URI getPrometheusMetricsURI(URI prometheusUri) {
        try {
            return new URI(prometheusUri.getScheme(), prometheusUri.getAuthority(), prometheusUri.getPath() + METRICS_ENDPOINT, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        String status = "";
        if (schema.equals("default")) {
            Object tableSupplierStatus;
            if (!((Map)this.tableSupplier.get()).isEmpty() && (tableSupplierStatus = ((Map)this.tableSupplier.get()).get("status")) instanceof String) {
                status = (String)tableSupplierStatus;
            }
            if (status.equals("success")) {
                List tableNames = (List)((Map)this.tableSupplier.get()).get("data");
                if (tableNames == null) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.copyOf((Collection)tableNames);
            }
            if (status.equals("warning")) {
                log.warn("Prometheus client gets a warning by retrieving table name from metric list");
            }
        }
        throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_TABLES_METRICS_RETRIEVE_ERROR, String.format("Prometheus did no return metrics list (table names): %s", status));
    }

    public PrometheusTable getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        if (!schema.equals("default")) {
            return null;
        }
        List tableNames = (List)((Map)this.tableSupplier.get()).get("data");
        if (tableNames == null) {
            return null;
        }
        if (!tableNames.contains(tableName)) {
            return null;
        }
        return new PrometheusTable(tableName, (List<PrometheusColumn>)ImmutableList.of((Object)new PrometheusColumn("labels", this.varcharMapType), (Object)new PrometheusColumn("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE), (Object)new PrometheusColumn("value", (Type)DoubleType.DOUBLE)));
    }

    private Map<String, Object> fetchMetrics(JsonCodec<Map<String, Object>> metricsCodec, URI metadataUri) {
        return (Map)metricsCodec.fromJson(this.fetchUri(metadataUri));
    }

    public byte[] fetchUri(URI uri) {
        Response response;
        Request.Builder requestBuilder = new Request.Builder().url(uri.toString());
        this.getBearerAuthInfoFromFile().map(bearerToken -> requestBuilder.header("Authorization", "Bearer " + bearerToken));
        try {
            if (this.config.isTlsEnabled()) {
                HostnameVerifier hostnameVerifier = (hostname, session) -> true;
                OkHttpClient httpClient = !this.config.getVerifyHostName() ? new OkHttpClient.Builder().hostnameVerifier(hostnameVerifier).sslSocketFactory(this.getSSLContext().getSocketFactory(), (X509TrustManager)this.getTrustManagerFactory().getTrustManagers()[0]).build() : new OkHttpClient.Builder().sslSocketFactory(this.getSSLContext().getSocketFactory(), (X509TrustManager)this.getTrustManagerFactory().getTrustManagers()[0]).build();
                response = httpClient.newCall(requestBuilder.build()).execute();
                if (response.isSuccessful() && response.body() != null) {
                    return response.body().bytes();
                }
            } else {
                response = httpClient.newCall(requestBuilder.build()).execute();
                if (response.isSuccessful() && response.body() != null) {
                    return response.body().bytes();
                }
            }
        }
        catch (SSLHandshakeException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "An SSL handshake error occurred while establishing a secure connection. Try the following measures to resolve the error:\n\n- Upload a valid SSL certificate for authentication\n- Verify the expiration status of the uploaded certificate.\n- If you are connecting with SSL, enable SSL on both ends of the connection.\n", (Throwable)e);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Peer verification failed. These measures might resolve the issue \n- Add correct Hostname in the SSL certificate's SAN list \n- The certificate chain might be incomplete. Check your SSL certificate\n", (Throwable)e);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Error reading metrics", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Requested cryptographic algorithm is not available", (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Keystore operation error", (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Key management operation error", (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Bad response " + response.code() + response.message());
    }

    private Optional<String> getBearerAuthInfoFromFile() {
        return this.bearerTokenFile.map(tokenFileName -> {
            try {
                return Files.readAllLines(tokenFileName.toPath(), StandardCharsets.UTF_8).toString();
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Failed to read bearer token file: " + tokenFileName, (Throwable)e);
            }
        });
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, this.getTrustManagerFactory().getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public TrustManagerFactory getTrustManagerFactory() throws KeyStoreException {
        KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            truststore.load(new URL("file://" + this.config.getTrustStorePath()).openStream(), this.config.getTruststorePassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            return trustManagerFactory;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "I/O Error", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Requested cryptographic algorithm is not available", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_SECURE_COMMUNICATION_ERROR, "Error while parsing or validating the certificate", (Throwable)e);
        }
    }
}

