/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.prometheus.PrometheusColumnHandle;
import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.plugin.prometheus.PrometheusMetricResult;
import com.facebook.presto.plugin.prometheus.PrometheusQueryResponse;
import com.facebook.presto.plugin.prometheus.PrometheusStandardizedRow;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.CountingInputStream;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PrometheusRecordCursor
implements RecordCursor {
    private final List<PrometheusColumnHandle> columnHandles;
    private final int[] fieldToColumnIndex;
    private final Iterator<PrometheusStandardizedRow> metricsItr;
    private final long totalBytes;
    private PrometheusStandardizedRow fields;

    public PrometheusRecordCursor(List<PrometheusColumnHandle> columnHandles, ByteSource byteSource) {
        this.columnHandles = columnHandles;
        this.fieldToColumnIndex = new int[columnHandles.size()];
        for (int i = 0; i < columnHandles.size(); ++i) {
            PrometheusColumnHandle columnHandle = columnHandles.get(i);
            this.fieldToColumnIndex[i] = columnHandle.getOrdinalPosition();
        }
        try (CountingInputStream input = new CountingInputStream(byteSource.openStream());){
            this.metricsItr = this.prometheusResultsInStandardizedForm(new PrometheusQueryResponse((InputStream)input).getResults()).iterator();
            this.totalBytes = input.getCount();
        }
        catch (PrestoException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_OUTPUT_ERROR, "Unable to handle Prometheus result: " + e.toString());
        }
    }

    static Block getBlockFromMap(Type mapType, Map<?, ?> map) {
        if (!(mapType instanceof MapType)) {
            return null;
        }
        Type keyType = (Type)mapType.getTypeParameters().get(0);
        Type valueType = (Type)mapType.getTypeParameters().get(1);
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder builder = mapBlockBuilder.beginBlockEntry();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            PrometheusRecordCursor.writeObject(builder, keyType, entry.getKey());
            PrometheusRecordCursor.writeObject(builder, valueType, entry.getValue());
        }
        mapBlockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)mapBlockBuilder, 0);
    }

    static Map<Object, Object> getMapFromBlock(Type type, Block block) {
        MapType mapType = (MapType)type;
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        HashMap<Object, Object> map = new HashMap<Object, Object>(block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            map.put(PrometheusRecordCursor.readObject(keyType, block, i), PrometheusRecordCursor.readObject(valueType, block, i + 1));
        }
        return map;
    }

    private static void writeObject(BlockBuilder builder, Type type, Object obj) {
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            BlockBuilder arrayBuilder = builder.beginBlockEntry();
            for (Object item : (List)obj) {
                PrometheusRecordCursor.writeObject(arrayBuilder, elementType, item);
            }
            builder.closeEntry();
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            BlockBuilder mapBlockBuilder = builder.beginBlockEntry();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                PrometheusRecordCursor.writeObject(mapBlockBuilder, mapType.getKeyType(), entry.getKey());
                PrometheusRecordCursor.writeObject(mapBlockBuilder, mapType.getValueType(), entry.getValue());
            }
            builder.closeEntry();
        } else if ("boolean".equals(type) || "tinyint".equals(type) || "smallint".equals(type) || "integer".equals(type) || "bigint".equals(type) || DoubleType.DOUBLE.equals((Object)type) || type instanceof VarcharType) {
            TypeUtils.writeNativeValue((Type)type, (BlockBuilder)builder, (Object)obj);
        }
    }

    private static Object readObject(Type type, Block block, int position) {
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return PrometheusRecordCursor.getArrayFromBlock(elementType, block.getBlock(position));
        }
        if (type instanceof MapType) {
            return PrometheusRecordCursor.getMapFromBlock(type, block.getBlock(position));
        }
        if (type.getJavaType() == Slice.class) {
            Slice slice = (Slice)Objects.requireNonNull(TypeUtils.readNativeValue((Type)type, (Block)block, (int)position));
            return type instanceof VarcharType ? slice.toStringUtf8() : (Object)slice.getBytes();
        }
        return TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
    }

    private static List<Object> getArrayFromBlock(Type elementType, Block block) {
        ImmutableList.Builder arrayBuilder = ImmutableList.builder();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            arrayBuilder.add(PrometheusRecordCursor.readObject(elementType, block, i));
        }
        return arrayBuilder.build();
    }

    private static Map<String, String> metricHeaderToMap(Map<String, String> mapToConvert) {
        return ImmutableMap.builder().putAll(mapToConvert).build();
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (!this.metricsItr.hasNext()) {
            return false;
        }
        this.fields = this.metricsItr.next();
        return true;
    }

    public boolean getBoolean(int field) {
        return true;
    }

    public long getLong(int field) {
        Type type = this.getType(field);
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            Instant dateTime = (Instant)Objects.requireNonNull(this.getFieldValue(field));
            int offsetMinutes = dateTime.atZone(ZoneId.systemDefault()).getOffset().getTotalSeconds() / 60;
            return DateTimeEncoding.packDateTimeWithZone((long)dateTime.toEpochMilli(), (int)offsetMinutes);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + this.getType(field));
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        return (Double)this.getFieldValue(field);
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Type)VarcharType.createUnboundedVarcharType());
        return Slices.utf8Slice((String)((String)Objects.requireNonNull(this.getFieldValue(field))));
    }

    public Object getObject(int field) {
        return this.getFieldValue(field);
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.getFieldValue(field) == null;
    }

    private Object getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        int columnIndex = this.fieldToColumnIndex[field];
        switch (columnIndex) {
            case 0: {
                return this.fields.getLabels();
            }
            case 1: {
                return this.fields.getTimestamp();
            }
            case 2: {
                return this.fields.getValue();
            }
        }
        return new NullPointerException();
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected field %s to be type %s but is %s", (Object)field, (Object)expected, (Object)actual);
    }

    private List<PrometheusStandardizedRow> prometheusResultsInStandardizedForm(List<PrometheusMetricResult> results) {
        return results.stream().map(result -> result.getTimeSeriesValues().getValues().stream().map(prometheusTimeSeriesValue -> new PrometheusStandardizedRow(PrometheusRecordCursor.getBlockFromMap(this.columnHandles.get(0).getColumnType(), PrometheusRecordCursor.metricHeaderToMap(result.getMetricHeader())), prometheusTimeSeriesValue.getTimestamp(), Double.parseDouble(prometheusTimeSeriesValue.getValue()))).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void close() {
    }
}

