/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.plugin.prometheus.PrometheusConnector;
import com.facebook.presto.plugin.prometheus.PrometheusHandleResolver;
import com.facebook.presto.plugin.prometheus.PrometheusModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class PrometheusConnectorFactory
implements ConnectorFactory {
    private static final String name = "prometheus";

    public String getName() {
        return name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new PrometheusHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "requiredConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new PrometheusModule(context.getTypeManager())});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(PrometheusConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

