/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;

public class PrometheusTimestampDeserializer
extends JsonDeserializer<Instant> {
    static Instant decimalEpochTimestampToSQLTimestamp(String timestamp) {
        long promTimestampMillis = (long)(Double.parseDouble(timestamp) * 1000.0);
        return Instant.ofEpochMilli(promTimestampMillis);
    }

    public Instant deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String timestamp = jsonParser.getText().trim();
        try {
            return PrometheusTimestampDeserializer.decimalEpochTimestampToSQLTimestamp(timestamp);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "unable to deserialize timestamp: " + e.getMessage());
        }
    }
}

