/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.plugin.prometheus.PrometheusClient;
import com.facebook.presto.plugin.prometheus.PrometheusColumnHandle;
import com.facebook.presto.plugin.prometheus.PrometheusRecordSet;
import com.facebook.presto.plugin.prometheus.PrometheusSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PrometheusRecordSetProvider
implements ConnectorRecordSetProvider {
    private final PrometheusClient prometheusClient;

    @Inject
    public PrometheusRecordSetProvider(PrometheusClient prometheusClient) {
        this.prometheusClient = Objects.requireNonNull(prometheusClient, "prometheusClient is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        PrometheusSplit prometheusSplit = (PrometheusSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((PrometheusColumnHandle)columnHandle));
        }
        return new PrometheusRecordSet(this.prometheusClient, prometheusSplit, (List<PrometheusColumnHandle>)handles.build());
    }
}

