/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.inject.Inject;

public class PrometheusClock {
    private final Clock clock;

    @Inject
    public PrometheusClock() {
        this(Clock.systemUTC());
    }

    private PrometheusClock(Clock clock) {
        this.clock = clock;
    }

    public static PrometheusClock fixedClockAt(LocalDateTime date) {
        return new PrometheusClock(Clock.fixed(date.atZone(ZoneId.systemDefault()).toInstant(), ZoneId.systemDefault()));
    }

    public Instant now() {
        return this.clock.instant();
    }

    public static PrometheusClock fixedClockAt(Instant fixedInstant) {
        return new PrometheusClock(Clock.fixed(fixedInstant, ZoneOffset.UTC));
    }
}

