/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.plugin.prometheus.PrometheusMetricResult;
import com.facebook.presto.plugin.prometheus.PrometheusTimeSeriesValue;
import com.facebook.presto.plugin.prometheus.PrometheusTimeSeriesValueArray;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PrometheusQueryResponse {
    private boolean status;
    private String error;
    private String errorType;
    private ResultType resultType;
    private String result;
    private List<PrometheusMetricResult> results;
    private final String parseResultStatus = "status";
    private final String parseResultSuccess = "success";
    private final String parseResultType = "resultType";
    private final String parseResult = "result";

    public PrometheusQueryResponse(InputStream response) throws IOException {
        this.parsePrometheusQueryResponse(response);
    }

    private void parsePrometheusQueryResponse(InputStream response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        JsonParser parser = new JsonFactory().createParser(response);
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            if (JsonToken.FIELD_NAME.equals((Object)jsonToken) && parser.getCurrentName().equals("status")) {
                parser.nextToken();
                if (parser.getValueAsString().equals("success")) {
                    this.status = true;
                    while (!parser.isClosed()) {
                        parser.nextToken();
                        if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                        if (parser.getCurrentName().equals("resultType")) {
                            parser.nextToken();
                            this.resultType = ResultType.valueOf(parser.getValueAsString());
                        }
                        if (!parser.getCurrentName().equals("result")) continue;
                        parser.nextToken();
                        ArrayNode node = (ArrayNode)mapper.readTree(parser);
                        this.result = node.toString();
                        break;
                    }
                } else {
                    String parsedStatus = parser.getValueAsString();
                    parser.nextToken();
                    parser.nextToken();
                    this.errorType = parser.getValueAsString();
                    parser.nextToken();
                    parser.nextToken();
                    this.error = parser.getValueAsString();
                    throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_PARSE_ERROR, "Unable to parse Prometheus response: " + parsedStatus + " " + this.errorType + " " + this.error);
                }
            }
            if (this.result == null) continue;
            break;
        }
        if (this.result != null && this.resultType != null) {
            switch (this.resultType) {
                case matrix: 
                case vector: {
                    this.results = (List)mapper.readValue(this.result, (TypeReference)new TypeReference<List<PrometheusMetricResult>>(){});
                    break;
                }
                case scalar: 
                case string: {
                    PrometheusTimeSeriesValue stringOrScalarResult = (PrometheusTimeSeriesValue)mapper.readValue(this.result, (TypeReference)new TypeReference<PrometheusTimeSeriesValue>(){});
                    HashMap<String, String> madeUpMetricHeader = new HashMap<String, String>();
                    madeUpMetricHeader.put("__name__", this.resultType.toString());
                    PrometheusTimeSeriesValueArray timeSeriesValues = new PrometheusTimeSeriesValueArray(Collections.singletonList(stringOrScalarResult));
                    this.results = Collections.singletonList(new PrometheusMetricResult(madeUpMetricHeader, timeSeriesValues));
                }
            }
        }
    }

    public String getError() {
        return this.error;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public List<PrometheusMetricResult> getResults() {
        return this.results;
    }

    public boolean getStatus() {
        return this.status;
    }

    static enum ResultType {
        matrix,
        vector,
        scalar,
        string;

    }
}

