/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.prometheus.PrometheusColumn;
import com.facebook.presto.plugin.prometheus.PrometheusConnectorConfig;
import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.plugin.prometheus.PrometheusTable;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PrometheusClient {
    public static final String METRICS_ENDPOINT = "/api/v1/label/__name__/values";
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().build();
    private final Optional<File> bearerTokenFile;
    private final Supplier<Map<String, Object>> tableSupplier;
    private final Type varcharMapType;
    private static final Logger log = Logger.get(PrometheusClient.class);

    @Inject
    public PrometheusClient(PrometheusConnectorConfig config, JsonCodec<Map<String, Object>> metricCodec, TypeManager typeManager) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(metricCodec, "metricCodec is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.bearerTokenFile = config.getBearerTokenFile();
        URI prometheusMetricsUri = PrometheusClient.getPrometheusMetricsURI(config.getPrometheusURI());
        this.tableSupplier = Suppliers.memoizeWithExpiration(() -> this.fetchMetrics(metricCodec, prometheusMetricsUri), (long)config.getCacheDuration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.varcharMapType = typeManager.getType(PrometheusColumn.mapType(VarcharType.VARCHAR.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()));
    }

    private static URI getPrometheusMetricsURI(URI prometheusUri) {
        try {
            return new URI(prometheusUri.getScheme(), prometheusUri.getAuthority(), prometheusUri.getPath() + METRICS_ENDPOINT, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        String status = "";
        if (schema.equals("default")) {
            Object tableSupplierStatus;
            if (!((Map)this.tableSupplier.get()).isEmpty() && (tableSupplierStatus = ((Map)this.tableSupplier.get()).get("status")) instanceof String) {
                status = (String)tableSupplierStatus;
            }
            if (status.equals("success")) {
                List tableNames = (List)((Map)this.tableSupplier.get()).get("data");
                if (tableNames == null) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.copyOf((Collection)tableNames);
            }
            if (status.equals("warning")) {
                log.warn("Prometheus client gets a warning by retrieving table name from metric list");
            }
        }
        throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_TABLES_METRICS_RETRIEVE_ERROR, String.format("Prometheus did no return metrics list (table names): %s", status));
    }

    public PrometheusTable getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        if (!schema.equals("default")) {
            return null;
        }
        List tableNames = (List)((Map)this.tableSupplier.get()).get("data");
        if (tableNames == null) {
            return null;
        }
        if (!tableNames.contains(tableName)) {
            return null;
        }
        return new PrometheusTable(tableName, (List<PrometheusColumn>)ImmutableList.of((Object)new PrometheusColumn("labels", this.varcharMapType), (Object)new PrometheusColumn("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE), (Object)new PrometheusColumn("value", (Type)DoubleType.DOUBLE)));
    }

    private Map<String, Object> fetchMetrics(JsonCodec<Map<String, Object>> metricsCodec, URI metadataUri) {
        return (Map)metricsCodec.fromJson(this.fetchUri(metadataUri));
    }

    public byte[] fetchUri(URI uri) {
        Response response;
        Request.Builder requestBuilder = new Request.Builder().url(uri.toString());
        this.getBearerAuthInfoFromFile().map(bearerToken -> requestBuilder.header("Authorization", "Bearer " + bearerToken));
        try {
            response = httpClient.newCall(requestBuilder.build()).execute();
            if (response.isSuccessful() && response.body() != null) {
                return response.body().bytes();
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Error reading metrics", (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Bad response " + response.code() + response.message());
    }

    private Optional<String> getBearerAuthInfoFromFile() {
        return this.bearerTokenFile.map(tokenFileName -> {
            try {
                return Files.readAllLines(tokenFileName.toPath(), StandardCharsets.UTF_8).toString();
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Failed to read bearer token file: " + tokenFileName, (Throwable)e);
            }
        });
    }
}

