/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.plugin.prometheus.PrometheusClient;
import com.facebook.presto.plugin.prometheus.PrometheusColumnHandle;
import com.facebook.presto.plugin.prometheus.PrometheusRecordCursor;
import com.facebook.presto.plugin.prometheus.PrometheusSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.util.List;
import java.util.Objects;

public class PrometheusRecordSet
implements RecordSet {
    private final List<PrometheusColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final ByteSource byteSource;

    public PrometheusRecordSet(PrometheusClient prometheusClient, PrometheusSplit split, List<PrometheusColumnHandle> columnHandles) {
        Objects.requireNonNull(prometheusClient, "prometheusClient is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (PrometheusColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.byteSource = ByteSource.wrap((byte[])prometheusClient.fetchUri(split.getUri()));
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new PrometheusRecordCursor(this.columnHandles, this.byteSource);
    }
}

