/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.plugin.prometheus.PrometheusClient;
import com.facebook.presto.plugin.prometheus.PrometheusClock;
import com.facebook.presto.plugin.prometheus.PrometheusConnector;
import com.facebook.presto.plugin.prometheus.PrometheusConnectorConfig;
import com.facebook.presto.plugin.prometheus.PrometheusMetadata;
import com.facebook.presto.plugin.prometheus.PrometheusRecordSetProvider;
import com.facebook.presto.plugin.prometheus.PrometheusSplitManager;
import com.facebook.presto.plugin.prometheus.PrometheusTable;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;
import javax.inject.Inject;

public class PrometheusModule
implements Module {
    private final TypeManager typeManager;

    public PrometheusModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(PrometheusConnector.class).in(Scopes.SINGLETON);
        binder.bind(PrometheusMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PrometheusClient.class).in(Scopes.SINGLETON);
        binder.bind(PrometheusSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(PrometheusClock.class).in(Scopes.SINGLETON);
        binder.bind(PrometheusRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PrometheusConnectorConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(PrometheusTable.class));
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, Object.class);
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        }
    }
}

