/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.prometheus.PrometheusClient;
import com.facebook.presto.plugin.prometheus.PrometheusColumnHandle;
import com.facebook.presto.plugin.prometheus.PrometheusTable;
import com.facebook.presto.plugin.prometheus.PrometheusTableHandle;
import com.facebook.presto.plugin.prometheus.PrometheusTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PrometheusMetadata
implements ConnectorMetadata {
    private final PrometheusClient prometheusClient;

    @Inject
    public PrometheusMetadata(PrometheusClient prometheusClient) {
        Objects.requireNonNull(prometheusClient, "client is null");
        this.prometheusClient = prometheusClient;
    }

    private static List<String> listSchemaNames() {
        return ImmutableList.copyOf((Collection)ImmutableSet.of((Object)"default"));
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return PrometheusMetadata.listSchemaNames();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        if (this.prometheusClient.getTable(tableName.getSchemaName(), tableName.getTableName()) == null) {
            return null;
        }
        return new PrometheusTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        PrometheusTableHandle tableHandle = (PrometheusTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new PrometheusTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(((PrometheusTableHandle)table).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        Set schemaNames = (Set)schemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf((Collection)ImmutableSet.of((Object)"default")));
        return (List)schemaNames.stream().flatMap(thisSchemaName -> this.prometheusClient.getTableNames((String)thisSchemaName).stream().map(tableName -> new SchemaTableName(thisSchemaName, tableName))).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PrometheusTableHandle prometheusTableHandle = (PrometheusTableHandle)tableHandle;
        PrometheusTable table = this.prometheusClient.getTable(prometheusTableHandle.getSchemaName(), prometheusTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(prometheusTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new PrometheusColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PrometheusColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!PrometheusMetadata.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        PrometheusTable table = this.prometheusClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.toSchemaTableName() == null || prefix.getTableName() == null) {
            return this.listTables(session, Optional.ofNullable(prefix.getSchemaName()));
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }
}

