/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class PrometheusSplit
implements ConnectorSplit {
    private final URI uri;
    private final List<HostAddress> addresses;

    @JsonCreator
    public PrometheusSplit(@JsonProperty(value="uri") URI uri) {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.addresses = ImmutableList.of((Object)HostAddress.fromUri((URI)uri));
    }

    @JsonProperty
    public URI getUri() {
        return this.uri;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        if (sortedCandidates == null || sortedCandidates.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "sortedCandidates is null or empty for Prometheus Split");
        }
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

