/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;

public class PrometheusConnectorConfig {
    private URI prometheusURI = URI.create("http://localhost:9090");
    private Duration queryChunkSizeDuration = new Duration(1.0, TimeUnit.DAYS);
    private Duration maxQueryRangeDuration = new Duration(1.0, TimeUnit.HOURS);
    private Duration cacheDuration = new Duration(30.0, TimeUnit.SECONDS);
    private File bearerTokenFile;

    @NotNull
    public URI getPrometheusURI() {
        return this.prometheusURI;
    }

    @Config(value="prometheus.uri")
    @ConfigDescription(value="Prometheus coordinator host address")
    public PrometheusConnectorConfig setPrometheusURI(URI prometheusURI) {
        this.prometheusURI = prometheusURI;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getQueryChunkSizeDuration() {
        return this.queryChunkSizeDuration;
    }

    @Config(value="prometheus.query-chunk-duration")
    @ConfigDescription(value="The duration of each query to Prometheus")
    public PrometheusConnectorConfig setQueryChunkSizeDuration(Duration queryChunkSizeDuration) {
        this.queryChunkSizeDuration = queryChunkSizeDuration;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getMaxQueryRangeDuration() {
        return this.maxQueryRangeDuration;
    }

    @Config(value="prometheus.max-query-duration")
    @ConfigDescription(value="Width of overall query to Prometheus, will be divided into prometheus.query-chunk-duration queries")
    public PrometheusConnectorConfig setMaxQueryRangeDuration(Duration maxQueryRangeDuration) {
        this.maxQueryRangeDuration = maxQueryRangeDuration;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Config(value="prometheus.cache-ttl")
    @ConfigDescription(value="How long values from this config file are cached")
    public PrometheusConnectorConfig setCacheDuration(Duration cacheConfigDuration) {
        this.cacheDuration = cacheConfigDuration;
        return this;
    }

    public Optional<File> getBearerTokenFile() {
        return Optional.ofNullable(this.bearerTokenFile);
    }

    @Config(value="prometheus.bearer-token-file")
    @ConfigDescription(value="File holding bearer token if needed for access to Prometheus")
    public PrometheusConnectorConfig setBearerTokenFile(File bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return this;
    }

    @PostConstruct
    public void checkConfig() {
        long queryChunkSizeDuration;
        long maxQueryRangeDuration = (long)this.getMaxQueryRangeDuration().getValue(TimeUnit.SECONDS);
        if (maxQueryRangeDuration < (queryChunkSizeDuration = (long)this.getQueryChunkSizeDuration().getValue(TimeUnit.SECONDS))) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("prometheus.max-query-duration must be greater than prometheus.query-chunk-duration")));
        }
    }
}

