/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.prometheus.PrometheusMetadata;
import com.facebook.presto.plugin.prometheus.PrometheusRecordSetProvider;
import com.facebook.presto.plugin.prometheus.PrometheusSplitManager;
import com.facebook.presto.plugin.prometheus.PrometheusTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class PrometheusConnector
implements Connector {
    private static final Logger log = Logger.get(PrometheusConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final PrometheusMetadata metadata;
    private final PrometheusSplitManager splitManager;
    private final PrometheusRecordSetProvider recordSetProvider;

    @Inject
    public PrometheusConnector(LifeCycleManager lifeCycleManager, PrometheusMetadata metadata, PrometheusSplitManager splitManager, PrometheusRecordSetProvider recordSetProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return PrometheusTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

