/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.postgresql;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Inject;
import org.postgresql.Driver;

public class PostgreSqlClient
extends BaseJdbcClient {
    @Inject
    public PostgreSqlClient(JdbcConnectorId connectorId, BaseJdbcConfig config) {
        super(connectorId, config, "\"", (ConnectionFactory)new DriverConnectionFactory((java.sql.Driver)new Driver(), config));
    }

    public void commitCreateTable(JdbcOutputTableHandle handle) {
        StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName())).append(" RENAME TO ").append(this.quoted(handle.getTableName()));
        try (Connection connection = this.getConnection(handle);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected ResultSet getTables(Connection connection, String schemaName, String tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String escape = metadata.getSearchStringEscape();
        return metadata.getTables(connection.getCatalog(), PostgreSqlClient.escapeNamePattern((String)schemaName, (String)escape), PostgreSqlClient.escapeNamePattern((String)tableName, (String)escape), new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE"});
    }

    protected String toSqlType(Type type) {
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return "bytea";
        }
        return super.toSqlType(type);
    }
}

