/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class JsonTypeUtil {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build();
    private static final ObjectMapper SORTED_MAPPER = new JsonObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    private JsonTypeUtil() {
    }

    public static Slice jsonParse(Slice slice) {
        Slice slice2;
        block8: {
            JsonParser parser = JsonTypeUtil.createJsonParser(JSON_FACTORY, slice);
            try {
                DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(slice.length());
                SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(parser, Object.class));
                parser.nextToken();
                slice2 = dynamicSliceOutput.slice();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert value to JSON: '%s'", slice.toStringUtf8()), (Throwable)e);
                }
            }
            parser.close();
        }
        return slice2;
    }

    private static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }
}

