/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static <T> T parseJson(Path path, Class<T> javaType) {
        if (!path.isAbsolute()) {
            path = path.toAbsolutePath();
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File does not exist: %s", (Object)path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"File is not readable: %s", (Object)path);
        try {
            byte[] json = Files.readAllBytes(path);
            ObjectMapper mapper = new JsonObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (T)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON file '%s' for '%s'", path, javaType), e);
        }
    }
}

