/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanSetUser(AccessControlContext context, Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(context, principal, userName);
    }

    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query) {
        this.delegate().checkQueryIntegrity(identity, context, query);
    }

    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(identity, context, propertyName);
    }

    public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
        this.delegate().checkCanAccessCatalog(identity, context, catalogName);
    }

    public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        return this.delegate().filterCatalogs(identity, context, catalogs);
    }

    public void checkCanCreateSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(identity, context, schema);
    }

    public void checkCanDropSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(identity, context, schema);
    }

    public void checkCanRenameSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(identity, context, schema, newSchemaName);
    }

    public void checkCanShowSchemas(Identity identity, AccessControlContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(identity, context, catalogName);
    }

    public Set<String> filterSchemas(Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(identity, context, catalogName, schemaNames);
    }

    public void checkCanCreateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanCreateTable(identity, context, table);
    }

    public void checkCanDropTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(identity, context, table);
    }

    public void checkCanRenameTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(identity, context, table, newTable);
    }

    public void checkCanShowTablesMetadata(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTablesMetadata(identity, context, schema);
    }

    public Set<SchemaTableName> filterTables(Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(identity, context, catalogName, tableNames);
    }

    public void checkCanAddColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(identity, context, table);
    }

    public void checkCanDropColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(identity, context, table);
    }

    public void checkCanRenameColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(identity, context, table);
    }

    public void checkCanSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(identity, context, table, columns);
    }

    public void checkCanInsertIntoTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(identity, context, table);
    }

    public void checkCanDeleteFromTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(identity, context, table);
    }

    public void checkCanCreateView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(identity, context, view);
    }

    public void checkCanDropView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(identity, context, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(identity, context, table, columns);
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, AccessControlContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(identity, context, catalogName, propertyName);
    }

    public void checkCanGrantTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(identity, context, privilege, table, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate().checkCanRevokeTablePrivilege(identity, context, privilege, table, revokee, grantOptionFor);
    }
}

