/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class TableAccessControlRule {
    private final Set<TablePrivilege> privileges;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> schemaRegex;
    private final Optional<Pattern> tableRegex;

    @JsonCreator
    public TableAccessControlRule(@JsonProperty(value="privileges") Set<TablePrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="table") Optional<Pattern> tableRegex) {
        this.privileges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privileges, "privileges is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "sourceRegex is null");
        this.tableRegex = Objects.requireNonNull(tableRegex, "tableRegex is null");
    }

    public Optional<Set<TablePrivilege>> match(String user, SchemaTableName table) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.schemaRegex.map(regex -> regex.matcher(table.getSchemaName()).matches()).orElse(true).booleanValue() && this.tableRegex.map(regex -> regex.matcher(table.getTableName()).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.privileges);
        }
        return Optional.empty();
    }

    public static enum TablePrivilege {
        SELECT,
        INSERT,
        DELETE,
        OWNERSHIP,
        GRANT_SELECT;

    }
}

